/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.state;

import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.service.state.TerminalStateAction;
import com.biz.crm.cps.business.participator.sdk.common.enums.TerminalAuditStatusEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class TerminalStateHolder {
    @Autowired
    private List<TerminalStateAction> terminalStateActions;
    private Map<String, TerminalStateAction> cache;

    private TerminalStateAction currentState(Terminal terminal) {
        String auditStatus = terminal.getAuditStatus();
        if (!CollectionUtils.isEmpty(this.cache)) {
            TerminalStateAction terminalState = this.cache.get(auditStatus);
            if (Objects.nonNull(terminalState)) {
                return terminalState;
            }
        } else {
            this.cache = new HashMap<String, TerminalStateAction>(this.terminalStateActions.size());
        }
        for (TerminalStateAction terminalState : this.terminalStateActions) {
            TerminalAuditStatusEnum terminalAuditStatus = terminalState.stateEnum();
            if (!auditStatus.equals(terminalAuditStatus.getDictCode())) continue;
            this.cache.put(auditStatus, terminalState);
            return terminalState;
        }
        return null;
    }

    @Transactional
    public void pass(Terminal terminal) {
        TerminalStateAction terminalState = this.currentState(terminal);
        Validate.notNull((Object)terminalState, (String)"\u7ec8\u7aef\u6570\u636e\u72b6\u6001\u975e\u6cd5", (Object[])new Object[0]);
        terminalState.pass(terminal);
    }

    @Transactional
    public void cancel(Terminal terminal) {
        TerminalStateAction terminalState = this.currentState(terminal);
        Validate.notNull((Object)terminalState, (String)"\u7ec8\u7aef\u6570\u636e\u72b6\u6001\u975e\u6cd5", (Object[])new Object[0]);
        terminalState.cancel(terminal);
    }
}

