/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.participator.local.service.state;

import com.biz.crm.cps.business.participator.local.entity.Terminal;
import com.biz.crm.cps.business.participator.local.repository.TerminalRepository;
import com.biz.crm.cps.business.participator.local.service.DealerService;
import com.biz.crm.cps.business.participator.local.service.state.TerminalStateAction;
import com.biz.crm.cps.business.participator.sdk.common.enums.TerminalAuditStatusEnum;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalSupplyVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class UnderReviewTerminalState
implements TerminalStateAction {
    @Autowired
    TerminalRepository terminalRepository;
    @Autowired
    private DealerService dealerService;
    @Autowired
    private TerminalMdmService terminalMdmService;

    @Override
    @Transactional
    public void pass(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u6570\u636e\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getId(), (String)"\u7ec8\u7aef\u6570\u636e\u7f3a\u5931\u4e3b\u952e", (Object[])new Object[0]);
        this.terminalRepository.updateAuditStatusById(TerminalAuditStatusEnum.AUDIT_SUCCESS.getDictCode(), terminal.getId());
        HashSet code = Sets.newHashSet();
        code.add(terminal.getTerminalCode());
        List terminalMdmVos = this.terminalMdmService.findDetailByCodes((Set)code);
        Validate.notEmpty((Collection)terminalMdmVos, (String)"\u6ca1\u6709\u53d1\u73b0\u9700\u8981\u51c6\u5165\u7684\u7ec8\u7aef\u4fe1\u606f,\u5ba1\u6279\u5931\u8d25", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet();
        TerminalMdmVo terminalMdmVo = (TerminalMdmVo)terminalMdmVos.get(0);
        List supplys = terminalMdmVo.getSupplys();
        if (CollectionUtils.isEmpty((Collection)supplys)) {
            return;
        }
        for (TerminalSupplyVo mdmVo : supplys) {
            String externalIdentifier = mdmVo.getCustomerCode();
            set.add(externalIdentifier);
        }
        this.dealerService.createBatch(set);
    }

    @Override
    @Transactional
    public void cancel(Terminal terminal) {
        Validate.notNull((Object)((Object)terminal), (String)"\u7ec8\u7aef\u6570\u636e\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminal.getId(), (String)"\u7ec8\u7aef\u6570\u636e\u7f3a\u5931\u4e3b\u952e", (Object[])new Object[0]);
        this.terminalRepository.updateAuditStatusById(TerminalAuditStatusEnum.AUDIT_REJECT.getDictCode(), terminal.getId());
    }

    @Override
    public TerminalAuditStatusEnum stateEnum() {
        return TerminalAuditStatusEnum.UNDER_REVIEW;
    }
}

