/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.local.controller;

import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskVo;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.display.local.service.DisplayTaskVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/display/task"})
@Api(tags={"\u9648\u5217\u4efb\u52a1Vo\u76f8\u5173\u63a5\u53e3"})
public class DisplayTaskVoController {
    private static final Logger log = LoggerFactory.getLogger(DisplayTaskVoController.class);
    @Autowired
    private DisplayTaskVoService displayTaskVoService;

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u5355\u53f7\u67e5\u8be2\u9648\u5217\u4efb\u52a1")
    @GetMapping(value={"findByBusinessCode"})
    public Result<DisplayTaskVo> findByBusinessCode(@RequestParam String businessCode) {
        try {
            DisplayTaskVo displayTaskVo = this.displayTaskVoService.findByBusinessCode(businessCode);
            return Result.ok((Object)displayTaskVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec8\u7aefcode\u67e5\u8be2\u4efb\u52a1\u5217\u8868(\u624b\u673a\u7aef)")
    @GetMapping(value={"findByTerminalCode"})
    public Result<List<DisplayTaskVo>> findByTerminalCode(@RequestParam String terminalCode, @RequestParam String taskStatus) {
        try {
            List<DisplayTaskVo> displayTaskVos = this.displayTaskVoService.findByTerminalCode(terminalCode, taskStatus);
            return Result.ok(displayTaskVos);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u5355\u53f7\u67e5\u8be2\u9648\u5217\u4efb\u52a1\u4e0a\u4f20\u56fe\u7247")
    @GetMapping(value={"findPictureByBusinessCode"})
    public Result<DisplayTaskVo> findPictureByBusinessCode(@RequestParam String businessCode) {
        try {
            DisplayTaskVo displayTaskVo = this.displayTaskVoService.findPictureByBusinessCode(businessCode);
            return Result.ok((Object)displayTaskVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

