/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.product.local.entity.ProductMaterial;
import com.biz.crm.cps.business.product.local.repository.ProductMaterialRepository;
import com.biz.crm.cps.business.product.local.service.ProductMaterialService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ProductMaterialServiceImpl
implements ProductMaterialService {
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ProductMaterialRepository productMaterialRepository;

    private ProductMaterial createForm(ProductMaterial productMaterial) {
        Date now = new Date();
        String account = this.getLoginAccountName();
        productMaterial.setCreateAccount(account);
        productMaterial.setCreateTime(now);
        productMaterial.setModifyAccount(account);
        productMaterial.setModifyTime(now);
        this.createValidation(productMaterial);
        return productMaterial;
    }

    @Override
    @Transactional
    public void createBatch(List<ProductMaterial> productMaterials) {
        if (CollectionUtils.isEmpty(productMaterials)) {
            return;
        }
        for (ProductMaterial productMaterial : productMaterials) {
            this.createForm(productMaterial);
        }
        this.productMaterialRepository.saveBatch(productMaterials);
    }

    @Override
    @Transactional
    public void saveBatch(List<ProductMaterial> target) {
        if (!CollectionUtils.isEmpty(target)) {
            Map<String, List<ProductMaterial>> productMaterialMap = target.stream().collect(Collectors.groupingBy(ProductMaterial::getProductCode));
            for (Map.Entry<String, List<ProductMaterial>> entry : productMaterialMap.entrySet()) {
                String productCode = entry.getKey();
                List<ProductMaterial> productMaterials = entry.getValue();
                List<ProductMaterial> old = this.productMaterialRepository.findByProductCode(productCode);
                if (!CollectionUtils.isEmpty(old)) {
                    this.productMaterialRepository.deleteByProductCode(productCode);
                }
                this.createBatch(productMaterials);
            }
        }
    }

    @Override
    public List<ProductMaterial> findByMaterialCode(String materialCode) {
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return null;
        }
        return this.productMaterialRepository.findByMaterialCode(materialCode);
    }

    @Override
    public List<ProductMaterial> findByProductCode(String productCode) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return null;
        }
        return this.productMaterialRepository.findByProductCode(productCode);
    }

    private void createValidation(ProductMaterial productMaterial) {
        Validate.notNull((Object)((Object)productMaterial), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        productMaterial.setId(null);
        Validate.notNull((Object)productMaterial.getNum(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productMaterial.getMaterialCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productMaterial.getProductCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((productMaterial.getNum() > 0 ? 1 : 0) != 0, (String)"\u7269\u6599\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            account = context.getAuthentication().getName();
        }
        return account;
    }
}

