/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.product.local.service.internal;

import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.product.local.entity.MaterialMedia;
import com.biz.crm.cps.business.product.local.repository.MaterialMediaRepository;
import com.biz.crm.cps.business.product.local.service.MaterialMediaService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MaterialMediaServiceImpl
implements MaterialMediaService {
    @Autowired
    private MaterialMediaRepository materialMediaRepository;

    @Override
    @Transactional
    public void createBatch(List<MaterialMedia> materialMedias) {
        Validate.notEmpty(materialMedias, (String)"\u7269\u6599\u56fe\u7247\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Map<String, List<MaterialMedia>> materialMediaMap = materialMedias.stream().collect(Collectors.groupingBy(MaterialMedia::getMaterialCode));
        for (Map.Entry<String, List<MaterialMedia>> entry : materialMediaMap.entrySet()) {
            String materialCode = entry.getKey();
            List<MaterialMedia> tempMaterialMedias = entry.getValue();
            List<MaterialMedia> old = this.materialMediaRepository.findByMaterialCode(materialCode);
            if (!CollectionUtils.isEmpty(old)) {
                this.materialMediaRepository.deleteByMaterialCode(materialCode);
            }
            for (MaterialMedia materialMedia : tempMaterialMedias) {
                this.createForm(materialMedia);
            }
            this.materialMediaRepository.saveBatch(tempMaterialMedias);
        }
    }

    private MaterialMedia createForm(MaterialMedia materialMedia) {
        Date now = new Date();
        String account = this.getLoginAccountName();
        materialMedia.setCreateAccount(account);
        materialMedia.setCreateTime(now);
        materialMedia.setModifyAccount(account);
        materialMedia.setModifyTime(now);
        this.createValidation(materialMedia);
        if (StringUtils.isBlank((CharSequence)materialMedia.getDelFlag())) {
            materialMedia.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)materialMedia.getEnableStatus())) {
            materialMedia.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        }
        return materialMedia;
    }

    @Override
    public MaterialMedia findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (MaterialMedia)((Object)this.materialMediaRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public MaterialMedia findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.materialMediaRepository.findDetailsById(id);
    }

    @Override
    public List<MaterialMedia> findByMaterialCode(String materialCode) {
        if (StringUtils.isBlank((CharSequence)materialCode)) {
            return null;
        }
        return this.materialMediaRepository.findByMaterialCode(materialCode);
    }

    private void createValidation(MaterialMedia materialMedia) {
        Validate.notNull((Object)((Object)materialMedia), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        materialMedia.setId(null);
        Validate.notNull((Object)materialMedia.getBusinessType(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u56fe\u7247\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialMedia.getMaterialCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)materialMedia.getMaterialId(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u7269\u6599id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)materialMedia.getFileName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((materialMedia.getUrlAddress() == null || materialMedia.getUrlAddress().length() < 255 ? 1 : 0) != 0, (String)"\u56fe\u7247\u5730\u5740\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((materialMedia.getFileName().length() < 128 ? 1 : 0) != 0, (String)"\u6587\u4ef6\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((materialMedia.getOriginalFileName() == null || materialMedia.getOriginalFileName().length() < 128 ? 1 : 0) != 0, (String)"\u6e90\u6587\u4ef6\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((materialMedia.getRelativeLocal() == null || materialMedia.getRelativeLocal().length() < 255 ? 1 : 0) != 0, (String)"\u5730\u5740\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private String getLoginAccountName() {
        SecurityContext context = SecurityContextHolder.getContext();
        String account = "admin";
        if (context != null && context.getAuthentication() != null) {
            account = context.getAuthentication().getName();
        }
        return account;
    }
}

