/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDetailVoRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDetailVoService;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDetailVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CostDetailVoServiceImpl
implements CostDetailVoService {
    private static final Logger log = LoggerFactory.getLogger(CostDetailVoServiceImpl.class);
    @Autowired
    private CostDetailVoRepository costDetailVoRepository;
    @Autowired
    private AgreementVoService agreementVoService;

    @Override
    public Page<CostDetailVo> findByConditions(String participatorCode, String participatorType, String yearAndMonth, Integer type, Pageable pageable) {
        List<CostDetailVo> billList;
        List agreements;
        LoginUserAgreementDto dto;
        List<CostDetailVo> list;
        if (StringUtils.isBlank((CharSequence)participatorCode) || StringUtils.isBlank((CharSequence)participatorType) || StringUtils.isBlank((CharSequence)yearAndMonth)) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        Page page = new Page();
        ArrayList<CostDetailVo> records = new ArrayList<CostDetailVo>();
        if (ParticipatorTypeEnum.DEALER.getDictCode().equals(participatorType)) {
            list = this.costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndDealer(participatorCode, yearAndMonth, type);
            if (!CollectionUtils.isEmpty(list)) {
                for (CostDetailVo vo : list) {
                    dto = new LoginUserAgreementDto();
                    dto.setTerminalCode(participatorCode);
                    dto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{vo.getTemplateCode()}));
                    agreements = this.agreementVoService.findByConditions(dto);
                    if (CollectionUtils.isEmpty((Collection)agreements)) continue;
                    vo.setAgreementCode(((AgreementVo)agreements.get(0)).getAgreementCode());
                    vo.setAgreementName(((AgreementVo)agreements.get(0)).getAgreementName());
                }
                records.addAll(list);
            }
            if (!CollectionUtils.isEmpty(billList = this.costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndBillDealer(participatorCode, yearAndMonth, type))) {
                billList.stream().forEach(item -> item.setAgreementName("\u54c1\u724c\u5546\u4e0a\u8d26\u8d39\u7528"));
                records.addAll(billList);
            }
        }
        if (ParticipatorTypeEnum.TERMINAL.getDictCode().equals(participatorType)) {
            list = this.costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndTerminal(participatorCode, yearAndMonth, type);
            if (!CollectionUtils.isEmpty(list)) {
                billList = list.iterator();
                while (billList.hasNext()) {
                    CostDetailVo vo;
                    vo = (CostDetailVo)billList.next();
                    dto = new LoginUserAgreementDto();
                    dto.setTerminalCode(participatorCode);
                    dto.setTemplateCodes((List)Lists.newArrayList((Object[])new String[]{vo.getTemplateCode()}));
                    agreements = this.agreementVoService.findByConditions(dto);
                    if (CollectionUtils.isEmpty((Collection)agreements)) continue;
                    vo.setAgreementCode(((AgreementVo)agreements.get(0)).getAgreementCode());
                    vo.setAgreementName(((AgreementVo)agreements.get(0)).getAgreementName());
                }
                records.addAll(list);
            }
            if (!CollectionUtils.isEmpty(billList = this.costDetailVoRepository.findByParticipatorCodeAndTimeAndTypeAndBillTerminal(participatorCode, yearAndMonth, type))) {
                billList.stream().forEach(item -> item.setAgreementName("\u8d39\u7528\u6838\u9500"));
                records.addAll(billList);
            }
        }
        page.setCurrent(page.getCurrent());
        page.setSize(page.getSize());
        page.setTotal(page.getTotal());
        page.setRecords(records);
        return page;
    }
}

