/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalBillEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostTerminalBillRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalBillService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalDetailService;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalBillDto;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CostTerminalBillServiceImpl
implements CostTerminalBillService {
    private static final Logger log = LoggerFactory.getLogger(CostTerminalBillServiceImpl.class);
    @Autowired
    private CostTerminalBillRepository costTerminalBillRepository;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CostTerminalService costTerminalService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private CostDealerDetailService costDealerDetailService;
    @Autowired
    private CostDealerService costDealerService;
    @Autowired
    private CostTerminalDetailService costTerminalDetailService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private DealerVoService dealerVoService;

    @Override
    public Page<CostTerminalBillEntity> findByConditions(CostTerminalBillDto costTerminalBillDto, Pageable pageable) {
        if (costTerminalBillDto == null) {
            return new Page();
        }
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        costTerminalBillDto.setTenantCode(TenantUtils.getTenantCode());
        return this.costTerminalBillRepository.findByConditions(costTerminalBillDto, pageable);
    }

    @Override
    @Transactional
    public CostTerminalBillEntity create(CostTerminalBillEntity terminalBillEntity) {
        List<TerminalVo> terminalVos = this.validateCreate(terminalBillEntity);
        TerminalVo terminalVo = terminalVos.get(0);
        CostTerminalBillEntity costTerminalBillEntity = (CostTerminalBillEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminalVo, CostTerminalBillEntity.class, HashSet.class, ArrayList.class, new String[0]));
        costTerminalBillEntity.setId(null);
        costTerminalBillEntity.setAmount(terminalBillEntity.getAmount());
        costTerminalBillEntity.setReviewStatus(1);
        CostTerminalEntity costTerminalEntity = this.costTerminalService.findByTerminalCode(terminalBillEntity.getTerminalCode());
        costTerminalBillEntity.setUnAuditFee(costTerminalEntity.getUnAuditFee());
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Date date = new Date();
        costTerminalBillEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        costTerminalBillEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        costTerminalBillEntity.setSubmitTime(date);
        costTerminalBillEntity.setCreateAccount(loginAccountName);
        costTerminalBillEntity.setCreateTime(date);
        costTerminalBillEntity.setModifyAccount(loginAccountName);
        costTerminalBillEntity.setModifyTime(date);
        List list = this.generateCodeService.generateCode("terminal_audit", 1);
        costTerminalBillEntity.setSourceCode((String)list.get(0));
        this.costTerminalBillRepository.save((Object)costTerminalBillEntity);
        Page<CostTerminalDetailEntity> costTerminalDetail = this.costTerminalDetailService.findByCostTerminalId(costTerminalEntity.getId(), (Pageable)PageRequest.of((int)0, (int)10000));
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)costTerminalDetail.getRecords()), (String)"\u7ecf\u9500\u5546\u8d39\u7528\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.updateTerminalDetail(costTerminalDetail.getRecords(), terminalBillEntity.getAmount());
        return costTerminalBillEntity;
    }

    private void updateTerminalDetail(List<CostTerminalDetailEntity> records, BigDecimal amount) {
        for (CostTerminalDetailEntity detail : records) {
            if (detail.getUnAuditFee().compareTo(amount) < 1) {
                detail.setUnAuditFee(BigDecimal.ZERO);
                detail.setAuditState(3);
                detail.setAuditedFee(detail.getAuditedFee().add(detail.getUnAuditFee()));
                amount = amount.subtract(detail.getUnAuditFee());
                this.costTerminalDetailService.update(detail);
                continue;
            }
            if (detail.getUnAuditFee().compareTo(amount) != 1) continue;
            detail.setUnAuditFee(detail.getUnAuditFee().subtract(amount));
            detail.setAuditState(2);
            detail.setAuditedFee(detail.getAuditedFee().add(amount));
            this.costTerminalDetailService.update(detail);
            break;
        }
    }

    @Override
    public Page<CostTerminalBillEntity> findByDealerCode(String dealerCode, Integer reviewStatus, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)dealerCode)) {
            return new Page();
        }
        List terminalCodes = this.terminalVoService.findByExternalIdentifier(dealerCode);
        Page<CostTerminalBillEntity> page = this.costTerminalBillRepository.findByReviewStatusAndTerminalCodes(reviewStatus, terminalCodes, pageable);
        return page;
    }

    @Override
    @Transactional
    public void approve(List<String> ids, Integer reviewStatus, String dealerCode) {
        Validate.notEmpty(ids, (String)"\u6279\u91cf\u5ba1\u6279\u65f6\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)reviewStatus, (String)"\u6279\u91cf\u5ba1\u6279\u65f6,\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (String id : ids) {
            CostTerminalBillEntity entity = (CostTerminalBillEntity)((Object)this.costTerminalBillRepository.getById((Serializable)((Object)id)));
            Validate.notNull((Object)((Object)entity), (String)"\u6279\u91cf\u5ba1\u6279\u65f6,\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            if (reviewStatus == 2) {
                entity.setReviewStatus(2);
                entity.setAuditTime(new Date());
                entity.setUnAuditFee(entity.getUnAuditFee().subtract(entity.getAmount()));
                CostTerminalEntity terminalEntity = this.costTerminalService.findByTerminalCode(entity.getTerminalCode());
                Validate.isTrue((terminalEntity.getUnAuditFee().compareTo(entity.getAmount()) != -1 ? 1 : 0) != 0, (String)"\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u672a\u6838\u9500\u91d1\u989d", (Object[])new Object[0]);
                BigDecimal auditedFee = terminalEntity.getAuditedFee() == null ? BigDecimal.ZERO : terminalEntity.getAuditedFee();
                BigDecimal unAuditFee = terminalEntity.getUnAuditFee() == null ? BigDecimal.ZERO : terminalEntity.getUnAuditFee();
                terminalEntity.setAuditedFee(auditedFee.add(entity.getAmount()));
                terminalEntity.setUnAuditFee(unAuditFee.subtract(entity.getAmount()));
                terminalEntity.setModifyTime(new Date());
                terminalEntity.setModifyAccount(this.loginUserService.getLoginAccountName());
                this.costTerminalService.update(terminalEntity);
                CostDealerDetailEntity dealerDetailEntity = new CostDealerDetailEntity();
                dealerDetailEntity.setSourceType("\u7ec8\u7aef\u6838\u9500\u6d41\u8f6c");
                dealerDetailEntity.setSourceCode(UUID.randomUUID().toString());
                dealerDetailEntity.setAmount(entity.getAmount());
                dealerDetailEntity.setBillState(2);
                dealerDetailEntity.setInOrOut(2);
                CostDealerEntity dealer = this.costDealerService.findByDealerCode(dealerCode);
                if (dealer == null) {
                    DealerVo dealerVo = this.dealerVoService.findByCustomerCode(dealerCode);
                    dealer = (CostDealerEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dealerVo, CostDealerEntity.class, HashSet.class, ArrayList.class, new String[0]));
                    dealer.setDealerCode(dealerVo.getCustomerCode());
                    dealer.setDealerName(dealerVo.getCustomerName());
                    dealer.setPhone(dealerVo.getCustomerContact());
                    dealer.setChannel(dealerVo.getChannelCode());
                    dealer.setTerminalCirculationFee(BigDecimal.ZERO);
                    dealer.setUnBilledFee(BigDecimal.ZERO);
                    dealer.setBilledFee(BigDecimal.ZERO);
                    dealer.setTotalAmount(BigDecimal.ZERO);
                    this.costDealerService.create(dealer);
                }
                Validate.notNull((Object)((Object)dealer), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ecf\u9500\u5546\u8d39\u7528\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                BigDecimal terminalCirculationFee = dealer.getTerminalCirculationFee() == null ? BigDecimal.ZERO : dealer.getTerminalCirculationFee();
                dealer.setTerminalCirculationFee(terminalCirculationFee.add(entity.getAmount()));
                dealerDetailEntity.setDealer(dealer);
                this.costDealerDetailService.create(dealerDetailEntity);
            }
            if (reviewStatus == 3) {
                entity.setReviewStatus(3);
                entity.setRejectTime(new Date());
            }
            entity.setModifyTime(new Date());
            entity.setModifyAccount(this.loginUserService.getLoginAccountName());
            this.costTerminalBillRepository.saveOrUpdate((Object)entity);
        }
    }

    private List<TerminalVo> validateCreate(CostTerminalBillEntity terminalBillEntity) {
        Validate.notNull((Object)((Object)terminalBillEntity), (String)"\u521b\u5efa\u65f6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalBillEntity.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List byTerminalCodes = this.terminalVoService.findByTerminalCodes(Arrays.asList(terminalBillEntity.getTerminalCode()));
        Validate.notEmpty((Collection)byTerminalCodes, (String)"\u7ec8\u7aef\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)terminalBillEntity.getAmount(), (String)"\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostTerminalEntity byTerminalCode = this.costTerminalService.findByTerminalCode(terminalBillEntity.getTerminalCode());
        BigDecimal bill = this.costTerminalBillRepository.sumByReviewStatusAndTerminalCode(1, terminalBillEntity.getTerminalCode());
        Validate.isTrue((byTerminalCode.getUnAuditFee().subtract(bill == null ? BigDecimal.ZERO : bill).compareTo(terminalBillEntity.getAmount()) != -1 ? 1 : 0) != 0, (String)"\u672c\u6b21\u7533\u8bf7\u7684\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u672a\u6838\u9500\u91d1\u989d", (Object[])new Object[0]);
        Validate.isTrue((terminalBillEntity.getTerminalCode() == null || terminalBillEntity.getTerminalCode().length() < 128 ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        return byTerminalCodes;
    }
}

