/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.cost.local.service.internal;

import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialDimensionVo;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerBillDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.repository.CostDealerBillDetailRepository;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerBillDetailService;
import java.math.BigDecimal;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CostDealerBillDetailServiceImpl
implements CostDealerBillDetailService {
    private static final Logger log = LoggerFactory.getLogger(CostDealerBillDetailServiceImpl.class);
    @Autowired
    private CostDealerBillDetailRepository costDealerBillDetailRepository;
    @Autowired
    private MaterialVoService materialVoService;

    @Override
    @Transactional
    public void createBatch(Set<CostDealerBillDetailEntity> billDetail) {
        this.validateCreate(billDetail);
        this.costDealerBillDetailRepository.saveBatch(billDetail);
    }

    private void validateCreate(Set<CostDealerBillDetailEntity> billDetail) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(billDetail), (String)"\u521b\u5efa\u660e\u7ec6\u65f6\uff0c\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (CostDealerBillDetailEntity item : billDetail) {
            Validate.notBlank((CharSequence)item.getPayType(), (String)"\u521b\u5efa\u660e\u7ec6\u65f6\uff0c\u4e0a\u8d26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (item.getPayType().equals("1")) {
                Validate.notBlank((CharSequence)item.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                MaterialDimensionVo material = this.materialVoService.findByMaterialCode(item.getMaterialCode());
                Validate.notNull((Object)material, (String)"\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)item.getMaterialName(), (String)"\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.isTrue((boolean)item.getMaterialName().equals(item.getMaterialName()), (String)"\u7269\u6599\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                Validate.isTrue((item.getMaterialCode() == null || item.getMaterialCode().length() < 128 ? 1 : 0) != 0, (String)"\u7269\u6599\u7f16\u7801,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
                Validate.isTrue((item.getMaterialName() == null || item.getMaterialName().length() < 255 ? 1 : 0) != 0, (String)"\u7269\u6599\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            }
            Validate.notNull((Object)item.getAmount(), (String)"\u4e0a\u8d26\u8d39\u7528\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((item.getAmount() == null || item.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4e0a\u8d26\u8d39\u7528\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        }
    }
}

