package com.biz.crm.cps.business.reward.integral.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 积分变动类型枚举
 * 数据库查询变动类型使用
 * @author 何帆
 */
public enum IntegralChangeTypeEnum {
  /**
   * 增加
   */
  ADD("add", "add", "增加", "1"),
  /**
   * 扣减
   */
  REDUCE("reduce", "reduce", "扣减", "2");

  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  IntegralChangeTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  public String getDictCode() {
    return dictCode;
  }

  /**
   * 通过key获取 IntegralChangeTypeEnum
   *
   * @param key
   * @return
   */
  public static IntegralChangeTypeEnum getByKey(String key) {
    return Arrays
        .stream(IntegralChangeTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }

  /**
   * 通过value获取 IntegralChangeTypeEnum
   *
   * @param value
   * @return
   */
  public static IntegralChangeTypeEnum getByValue(String value) {
    return Arrays.stream(IntegralChangeTypeEnum.values())
        .filter(item -> Objects.equals(item.getValue(), value))
        .findFirst().orElse(null);
  }
}
