package com.biz.crm.cps.business.reward.integral.sdk.dto;

import com.biz.crm.cps.business.reward.sdk.common.enums.IncomeStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分流水记录Dto
 * @author 何帆
 */
@Data
@ApiModel(value = "KeepBooksDto", description = "积分流水记录Dto")
public class IntegralDetailDto {

  @ApiModelProperty(value = "id")
  private String id;
  /**
   * 积分变动流水编码
   */
  @ApiModelProperty(value = "积分变动流水编码")
  private String code;
  /**
   * 发放角色
   */
  @ApiModelProperty(value = "客户类型")
  private String participatorType;
  /**
   * 角色编码
   */
  @ApiModelProperty(value = "客户编码")
  private String participatorCode;
  /**
   * 角色名称
   */
  @ApiModelProperty(value = "客户名称")
  private String participatorName;

  @ApiModelProperty(value = "客户标签")
  private String tag;

  @ApiModelProperty(value = "组织编码")
  private String orgCode;

  @ApiModelProperty(value = "组织名称")
  private String orgName;

  @ApiModelProperty(value = "渠道")
  private String channel;

  @ApiModelProperty(value = "联系电话")
  private String phone;

  /**
   * 触发动作所属政策
   */
  @ApiModelProperty(value = "政策名称")
  private String policyName;

  @ApiModelProperty(value = "触发动作")
  private String triggerAction;

  @ApiModelProperty(value = "触发对象")
  private String triggerObject;

  @ApiModelProperty(value = "变动数量")
  private BigDecimal amount;

  @ApiModelProperty(value = "积分余额")
  private BigDecimal balance;

  @ApiModelProperty(value = "积分id")
  private String integralId;

  @ApiModelProperty(value = "分利协议编码")
  private String agreementCode;

  @ApiModelProperty(value = "模板编码")
  private String templateCode;

  @ApiModelProperty(value = "扫码记录编码")
  private String recordCode;

  private String tenantCode;

  @ApiModelProperty(value = "删除标识")
  private String delFlag;

  @ApiModelProperty(value = "启用禁用标识")
  private String enableStatus;

  @ApiModelProperty(value = "备注")
  private String remark;

  @ApiModelProperty(value = "创建时间开始")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;

  @ApiModelProperty(value = "创建时间结束")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;

  /**
   * @see IncomeStatusEnum
   */
  @ApiModelProperty(value = "积分流水变动类型")
  private String type;

  @ApiModelProperty(value = "创建人账号")
  private String createAccount;

  @ApiModelProperty(value = "创建时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  @ApiModelProperty(value = "更新人账号")
  private String modifyAccount;

  @ApiModelProperty(value = "最后更新时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;

  @ApiModelProperty(value = "年月",example = "2021-08")
  private String yearAndMonth;
}
