package com.biz.crm.cps.business.reward.integral.sdk.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 积分信息Dto
 * @author 何帆
 */
@Data
@ApiModel(value = "IntegralDto", description = "积分Dto")
public class IntegralDto {

  @ApiModelProperty(value = "id")
  private String id;

  @ApiModelProperty(value = "客户编码")
  private String participatorCode;

  /**
   * 客户编码集合
   */
  @ApiModelProperty(value = "客户编码集合")
  private List<String> participatorCodes;

  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户类型")
  private String participatorType;
  /**
   * 渠道
   */
  @ApiModelProperty(value = "渠道类型")
  private String channel;
  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String participatorName;
  /**
   * 客户标签
   */
  @ApiModelProperty(value = "客户标签")
  private String tag;
  /**
   * 所属组织编码
   */
  @ApiModelProperty(value = "所属组织编码")
  private String orgCode;
  /**
   * 所属组织名称
   */
  @ApiModelProperty(value = "所属组织名称")
  private String orgName;
  /**
   * 积分余额
   */
  @ApiModelProperty(value = "积分余额")
  private BigDecimal balance;
  /**
   * 累计积分
   */
  @ApiModelProperty(value = "累计分利积分")
  private BigDecimal accruingIntegral;
  /**
   * 联系电话
   */
  @ApiModelProperty(value = "联系电话")
  private String phone;

  private String tenantCode;

  @ApiModelProperty(value = "删除标识")
  private String delFlag;

  @ApiModelProperty(value = "启用状态")
  private String enableStatus;

  @ApiModelProperty(value = "备注")
  private String remark;

  @ApiModelProperty(value = "更新时间开始")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private String modifyTimeStart;

  @ApiModelProperty(value = "更新时间结束")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private String modifyTimeEnd;

  @ApiModelProperty(value = "创建人账号")
  private String createAccount;

  @ApiModelProperty(value = "创建时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  @ApiModelProperty(value = "更新人账号")
  private String modifyAccount;

  @ApiModelProperty(value = "最后更新时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;
}
