package com.biz.crm.cps.business.reward.integral.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 积分流水响应vo
 * @author 何帆
 */
@Data
@ApiModel(value = "IntegralDetailRespVo", description = "积分明细流水响应vo")
public class IntegralDetailRespVo {

  /**
   * 积分变动流水编码
   */
  @ApiModelProperty(value = "积分变动流水编码")
  private String code;
  /**
   * 发放角色
   */
  @ApiModelProperty(value = "客户类型")
  private String participatorType;
  /**
   * 角色编码
   */
  @ApiModelProperty(value = "客户编码")
  private String participatorCode;
  /**
   * 角色名称
   */
  @ApiModelProperty(value = "客户名称")
  private String participatorName;

  @ApiModelProperty(value = "组织编码")
  private String orgCode;

  @ApiModelProperty(value = "组织名称")
  private String orgName;

  @ApiModelProperty(value = "渠道")
  private String channel;
  /**
   * 手机号
   */
  @ApiModelProperty(value = "联系电话")
  private String phone;
  /**
   * 变动原因--h5页面使用，根据触发动作，存储
   */
  @ApiModelProperty(value = "变动原因")
  private String changeReason;

  @ApiModelProperty(value = "政策名称")
  private String policyName;
  /**
   * 触发动作
   */
  @ApiModelProperty(value = "触发动作")
  private String triggerAction;
  /**
   * 触发对象
   */
  @ApiModelProperty(value = "触发对象")
  private String triggerObject;
  /**
   * 变动金额
   */
  @ApiModelProperty(value = "变动数量")
  private BigDecimal amount;
  /**
   * 积分余额
   */
  @ApiModelProperty(value = "积分余额")
  private BigDecimal balance;
  /**
   * 积分id
   */
  @ApiModelProperty(value = "积分id")
  private String integralId;
  /**
   * 协议编码
   */
  @ApiModelProperty(value = "分利协议编码")
  private String agreementCode;

  @ApiModelProperty(value = "分利协议名称")
  private String agreementName;

  @ApiModelProperty(value = "协议模板编码")
  private String templateCode;

  @ApiModelProperty(value = "协议模板名称")
  private String templateName;

  @ApiModelProperty(value = "扫码记录编码")
  private String recordCode;

  @ApiModelProperty(value = "创建人账号")
  private String createAccount;

  @ApiModelProperty(value = "创建时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  @ApiModelProperty(value = "更新人账号")
  private String modifyAccount;

  @ApiModelProperty(value = "最后更新时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  private Date modifyTime;

  @ApiModelProperty(value = "备注")
  private String remark;

  @ApiModelProperty(value = "年月",example = "2021-08")
  private String yearAndMonth;
}
