package com.biz.crm.cps.business.reward.integral.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.reward.integral.sdk.dto.IntegralDetailDto;
import com.biz.crm.cps.business.reward.integral.sdk.vo.IntegralDetailRespVo;
import org.springframework.data.domain.Pageable;

/**
 * 积分流水响应接口
 * @author 何帆
 */
public interface IntegralDetailRespVoService {

  /**
   * 根据 条件 查询积分流水明细
   *
   * @param pageable 分页信息
   * @param reqVo    积分明细查询条件
   * @return 积分流水分页
   */
  Page<IntegralDetailRespVo> findByConditions(Pageable pageable, IntegralDetailDto reqVo);

  /**
   * 扣除积分
   * @param dto
   * @return
   */
  IntegralDetailRespVo deduct(IntegralDetailDto dto);
}
