package com.biz.crm.cps.business.reward.integral.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 积分(Integral)实体类
 * 积分信息
 * @author makejava
 * @since 2021-08-19 14:04:28
 */

@Data
@TableName("reward_integral")
@ApiModel(value = "IntegralEntity", description = "客户积分信息")
public class IntegralVo extends TenantFlagOpVo {

  @ApiModelProperty(value = "客户编码")
  private String participatorCode;
  /**
   * 客户名称
   */

  @ApiModelProperty(value = "客户类型")
  private String participatorType;
  /**
   * 渠道
   */
  @ApiModelProperty(value = "渠道类型")
  private String channel;
  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String participatorName;
  /**
   * 客户标签
   */
  @ApiModelProperty(value = "客户标签")
  private String tag;
  /**
   * 所属组织编码
   */
  @ApiModelProperty(value = "所属组织编码")
  private String orgCode;
  /**
   * 所属组织名称
   */
  @ApiModelProperty(value = "所属组织名称")
  private String orgName;
  /**
   * 积分余额
   */
  @ApiModelProperty(value = "积分余额")
  private BigDecimal balance;
  /**
   * 累计积分
   */
  @ApiModelProperty(value = "累计分利积分")
  private BigDecimal accruingIntegral;
  /**
   * 联系电话
   */
  @ApiModelProperty(value = "联系电话")
  private String phone;
}
