/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.local.service.internal;

import com.biz.crm.cps.business.reward.sdk.dto.CashRandomDto;
import com.biz.crm.cps.business.reward.sdk.service.RandomQuotaComputeService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Component(value="RandomQuotaComputeServiceImpl")
@ConditionalOnMissingBean(name={"RandomQuotaComputeServiceExpandImpl"})
public class RandomQuotaComputeServiceImpl
implements RandomQuotaComputeService {
    private static final Logger log = LoggerFactory.getLogger(RandomQuotaComputeServiceImpl.class);

    public BigDecimal execute(List<CashRandomDto> params) {
        AtomicReference<BigDecimal> returnCash = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(params)) {
            BigDecimal totalWeight = params.stream().map(CashRandomDto::getPercent).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            BigDecimal randomNum = new BigDecimal(Math.random() * (double)totalWeight.floatValue());
            BigDecimal exactRandomNum = randomNum.setScale(2, 1);
            AtomicReference<BigDecimal> atomicRandomNum = new AtomicReference<BigDecimal>(exactRandomNum);
            int num = 0;
            for (CashRandomDto randomVo : params) {
                BigDecimal percent = randomVo.getPercent() == null ? BigDecimal.ZERO : randomVo.getPercent();
                BigDecimal exactPercent = percent.setScale(2, 1);
                BigDecimal subtract = atomicRandomNum.get().subtract(exactPercent);
                num = subtract.compareTo(BigDecimal.ZERO);
                if (num > 0) {
                    atomicRandomNum.set(subtract);
                    continue;
                }
                returnCash.set(randomVo.getCash());
                break;
            }
            if (num > 0) {
                CashRandomDto minCash = params.stream().sorted(Comparator.comparing(CashRandomDto::getCash)).findFirst().get();
                return minCash.getCash();
            }
        }
        return returnCash.get();
    }
}

