/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.redpacket.local.config.CashProperties;
import com.biz.crm.cps.business.reward.redpacket.local.config.RedPacketProperties;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketRewardCashProcessVoService;
import com.biz.crm.cps.business.reward.sdk.dto.RewardCashConditionDto;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardCashObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardCashProcessVo;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RedPacketRewardCashProcessVoServiceImpl")
public class RedPacketRewardCashProcessVoServiceImpl
implements RedPacketRewardCashProcessVoService {
    @Autowired(required=false)
    private List<RewardCashObserver> rewardCashObserverList;
    @Autowired(required=false)
    private RedPacketProperties redPacketProperties;
    @Autowired
    private RedPacketService redPacketService;
    @Autowired
    private LoginUserService loginUserService;

    public RewardCashProcessVo findByParticipator(RewardCashConditionDto conditionDto) {
        if (CollectionUtils.isEmpty(this.rewardCashObserverList) || Objects.isNull(conditionDto)) {
            return null;
        }
        Iterator<RewardCashObserver> iterator = this.rewardCashObserverList.iterator();
        if (iterator.hasNext()) {
            RewardCashObserver rewardCashObserver = iterator.next();
            this.buildCashType(conditionDto);
            RewardCashProcessVo cashProcessVo = rewardCashObserver.onRequestCashProcess(conditionDto);
            return cashProcessVo;
        }
        return null;
    }

    public RewardCashProcessVo findByCurrentUser() {
        LoginUserDetails userDetails = this.loginUserService.getLoginUser();
        ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey((String)userDetails.getUsertype());
        RewardCashConditionDto conditionDto = new RewardCashConditionDto();
        conditionDto.setParticipatorCode(userDetails.getConsumerCode());
        conditionDto.setParticipatorName(userDetails.getConsumerName());
        conditionDto.setParticipatorFlag(participatorTypeEnum.getDictCode());
        conditionDto.setPayeeCode(userDetails.getAccount());
        conditionDto.setPayeeName(userDetails.getRealName());
        return this.findByParticipator(conditionDto);
    }

    public void validate(RewardCashConditionDto conditionDto) {
        Validate.notNull((Object)conditionDto, (String)"\u5151\u4ed8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal amount = conditionDto.getAmount();
        String participatorCode = conditionDto.getParticipatorCode();
        String participatorName = conditionDto.getParticipatorName();
        String participatorType = conditionDto.getParticipatorFlag();
        Validate.notNull((Object)amount, (String)"\u51cf\u5c11\u4f59\u989d\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((amount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u51cf\u5c11\u4f59\u989d\u65f6\uff0c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)participatorType, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)participatorName, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RewardCashProcessVo rewardCashProcessVo = this.findByParticipator(conditionDto);
        Validate.notNull((Object)rewardCashProcessVo, (String)"\u3010%s\u3011\uff1a\u7f3a\u5c11\u5151\u73b0\u914d\u7f6e", (Object[])new Object[]{participatorName});
        Validate.isTrue((!rewardCashProcessVo.isNeedSign() ? 1 : 0) != 0, (String)"\u3010%s\u3011\uff1a\u5151\u73b0\u9700\u8981\u7b7e\u7f72\u670d\u52a1\u5408\u540c", (Object[])new Object[]{participatorName});
        Validate.isTrue((!rewardCashProcessVo.isNeedVerify() ? 1 : 0) != 0, (String)"\u3010%s\u3011\uff1a\u5151\u73b0\u9700\u8981\u5b9e\u540d\u8ba4\u8bc1", (Object[])new Object[]{participatorName});
        RedPacketEntity redPacket = this.redPacketService.findByParticipatorCode(participatorCode);
        Validate.notNull((Object)((Object)redPacket), (String)"\u3010%s\u3011\uff1a\u8fd8\u672a\u83b7\u5f97\u7ea2\u5305", (Object[])new Object[]{participatorName});
        BigDecimal balance = redPacket.getBalance() == null ? BigDecimal.ZERO : redPacket.getBalance();
        Validate.isTrue((balance.compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u63d0\u73b0\u91d1\u989d\u5927\u4e8e\u4f59\u989d", (Object[])new Object[0]);
    }

    public void buildCashType(RewardCashConditionDto conditionDto) {
        Validate.notNull((Object)conditionDto, (String)"\u5151\u4ed8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CashProperties> cashProperties = this.redPacketProperties.getCashs();
        Validate.notEmpty(cashProperties, (String)"\u7cfb\u7edf\u7f3a\u5c11\u7ea2\u5305\u63d0\u73b0\u914d\u7f6e", (Object[])new Object[0]);
        CashProperties cashProp = cashProperties.stream().filter(item -> Objects.equals(conditionDto.getParticipatorFlag(), item.getParticipatorType())).findAny().orElse(null);
        Validate.notNull((Object)cashProp, (String)"\u7cfb\u7edf\u7f3a\u5c11\u3010%s\u3011\u7c7b\u578b\u7684\u7ea2\u5305\u63d0\u73b0\u914d\u7f6e", (Object[])new Object[]{conditionDto.getParticipatorFlag()});
        conditionDto.setCashKey(cashProp.getCashKey());
    }
}

