/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeEvent;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeExpression;
import com.biz.crm.cps.business.policy.scan.local.mapper.ScanCodeConfigurationMapper;
import com.biz.crm.cps.business.policy.scan.local.repository.ScanCodeConfigurationRepository;
import com.biz.crm.cps.business.policy.scan.local.service.ScanCodeConfigurationService;
import com.biz.crm.cps.business.policy.scan.local.service.ScanCodeEventService;
import com.biz.crm.cps.business.policy.scan.local.service.ScanCodeRangeService;
import com.biz.crm.cps.business.policy.scan.sdk.dto.ScanCodeConfigurationDto;
import com.biz.crm.cps.business.policy.scan.sdk.dto.ScanCodeExpresionDto;
import com.biz.crm.cps.business.policy.scan.sdk.dto.ScanCodeParticipatorDto;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeConfigurationServiceImpl
implements ScanCodeConfigurationService {
    @Autowired
    private ScanCodeConfigurationRepository scanCodeConfigurationRepository;
    @Autowired
    ScanCodeRangeService scanCodeRangeService;
    @Autowired
    ScanCodeEventService scanCodeEventService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public ScanCodeConfiguration create(AgreementPolicyDto agreementPolicyDto) {
        ScanCodeConfiguration scanCodeConfiguration = this.mapping(agreementPolicyDto);
        if (Objects.isNull((Object)scanCodeConfiguration)) {
            return null;
        }
        Set<ScanCodeEvent> scanCodeEvents = scanCodeConfiguration.getScanCodeEvents();
        if (CollectionUtils.isEmpty(scanCodeEvents)) {
            return null;
        }
        ScanCodeConfiguration current = this.createForm(scanCodeConfiguration);
        this.scanCodeConfigurationRepository.save((Object)current);
        this.scanCodeRangeService.create(current);
        this.scanCodeEventService.create(current);
        return current;
    }

    @Override
    public List<ScanCodeConfiguration> findDetailsByTemplateCodes(Set<String> templateCodes) {
        if (CollectionUtils.isEmpty(templateCodes)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.scanCodeConfigurationRepository.findDetailsByTemplateCodes(templateCodes, tenantCode);
    }

    @Override
    public List<ScanCodeConfiguration> findDetailsByTemplateCode(String templateCode) {
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.scanCodeConfigurationRepository.findDetailsByTemplateCode(templateCode, tenantCode);
    }

    @Override
    @Transactional
    public void onDeleteByTemplateCode(String templateCode) {
        QueryWrapper scanCodeConfigurationQueryWrapper = new QueryWrapper();
        scanCodeConfigurationQueryWrapper.eq((Object)"template_code", (Object)templateCode);
        List scanCodeConfigurationList = ((ScanCodeConfigurationMapper)this.scanCodeConfigurationRepository.getBaseMapper()).selectList((Wrapper)scanCodeConfigurationQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)scanCodeConfigurationList)) {
            scanCodeConfigurationList.forEach(item -> {
                this.scanCodeRangeService.deleteByConfigurationId(item.getId());
                this.scanCodeEventService.deleteByConfigurationId(item.getId());
            });
            ((ScanCodeConfigurationMapper)this.scanCodeConfigurationRepository.getBaseMapper()).delete((Wrapper)scanCodeConfigurationQueryWrapper);
        }
    }

    private ScanCodeConfiguration createForm(ScanCodeConfiguration scanCodeConfiguration) {
        Date now = new Date();
        String account = this.loginUserService.getLoginAccountName();
        scanCodeConfiguration.setTenantCode(TenantUtils.getTenantCode());
        scanCodeConfiguration.setCreateAccount(account);
        scanCodeConfiguration.setCreateTime(now);
        scanCodeConfiguration.setModifyAccount(account);
        scanCodeConfiguration.setModifyTime(now);
        this.createValidation(scanCodeConfiguration);
        return scanCodeConfiguration;
    }

    private void createValidation(ScanCodeConfiguration entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getTenantCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getDimensionFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u626b\u7801\u4ea7\u54c1\u7ef4\u5ea6\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getDimensionName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u626b\u7801\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getDimensionFlag() == null || entity.getDimensionFlag().length() < 32 ? 1 : 0) != 0, (String)"\u626b\u7801\u4ea7\u54c1\u7ef4\u5ea6\u6807\u8bc6,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getDimensionName() == null || entity.getDimensionName().length() < 32 ? 1 : 0) != 0, (String)"\u626b\u7801\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private ScanCodeConfiguration mapping(AgreementPolicyDto agreementPolicyDto) {
        if (agreementPolicyDto instanceof ScanCodeConfigurationDto) {
            String separator = "@";
            ScanCodeConfigurationDto dto = (ScanCodeConfigurationDto)agreementPolicyDto;
            ScanCodeConfiguration scanCodeConfiguration = (ScanCodeConfiguration)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, ScanCodeConfiguration.class, HashSet.class, LinkedList.class, new String[0]));
            Set scanCodeParticipators = dto.getScanCodeParticipators();
            HashSet scanCodeEvents = Sets.newHashSet();
            for (ScanCodeParticipatorDto scanCodeParticipator : scanCodeParticipators) {
                Set scanCodeExpressionsDto = scanCodeParticipator.getScanCodeExpressions();
                Map<String, List<ScanCodeExpresionDto>> barCodeTypeflagMap = scanCodeExpressionsDto.stream().collect(Collectors.groupingBy(scanCodeExpresionDto -> StringUtils.join((Object[])new String[]{scanCodeExpresionDto.getBarCodeTypeFlag(), separator, scanCodeExpresionDto.getBarCodeTypeName()})));
                for (Map.Entry<String, List<ScanCodeExpresionDto>> entry : barCodeTypeflagMap.entrySet()) {
                    String key = entry.getKey();
                    String[] split = key.split(separator);
                    ScanCodeEvent scanCodeEvent = new ScanCodeEvent();
                    scanCodeEvent.setParticipatorFlag(scanCodeParticipator.getParticipatorFlag());
                    scanCodeEvent.setParticipatorName(scanCodeParticipator.getParticipatorName());
                    scanCodeEvent.setBarCodeTypeFlag(split[0]);
                    scanCodeEvent.setBarCodeTypeName(split[1]);
                    HashSet scanCodeExpressions = Sets.newHashSet((Iterable)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entry.getValue(), ScanCodeExpresionDto.class, ScanCodeExpression.class, HashSet.class, LinkedList.class, new String[0]));
                    scanCodeEvent.setScanCodeExpressions(scanCodeExpressions);
                    scanCodeEvents.add(scanCodeEvent);
                }
            }
            scanCodeConfiguration.setScanCodeEvents(scanCodeEvents);
            return scanCodeConfiguration;
        }
        return null;
    }
}

