/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.scan.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.local.entity.ScanCodeEvent;
import com.biz.crm.cps.business.policy.scan.local.mapper.ScanCodeEventMapper;
import com.biz.crm.cps.business.policy.scan.local.repository.ScanCodeEventRepository;
import com.biz.crm.cps.business.policy.scan.local.service.ScanCodeEventService;
import com.biz.crm.cps.business.policy.scan.local.service.ScanCodeExpressionService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeEventServiceImpl
implements ScanCodeEventService {
    @Autowired
    ScanCodeEventRepository scanCodeEventRepository;
    @Autowired
    ScanCodeExpressionService scanCodeExpressionService;

    @Override
    @Transactional
    public void create(ScanCodeConfiguration current) {
        Validate.notNull((Object)((Object)current), (String)"\u626b\u7801\u914d\u7f6e\u4fe1\u606f\u672a\u4f20", (Object[])new Object[0]);
        Set<ScanCodeEvent> scanCodeEvents = current.getScanCodeEvents();
        Validate.isTrue((!CollectionUtils.isEmpty(scanCodeEvents) ? 1 : 0) != 0, (String)"\u626b\u7801\u4e8b\u4ef6\u4fe1\u606f\u672a\u914d\u7f6e", (Object[])new Object[0]);
        for (ScanCodeEvent scanCodeEvent : scanCodeEvents) {
            scanCodeEvent.setConfigurationId(current.getId());
            this.createValidation(scanCodeEvent);
        }
        this.scanCodeEventRepository.saveBatch(scanCodeEvents);
        for (ScanCodeEvent scanCodeEvent : scanCodeEvents) {
            this.scanCodeExpressionService.create(scanCodeEvent);
        }
    }

    @Override
    @Transactional
    public void deleteByConfigurationId(String configurationId) {
        if (StringUtils.isNotBlank((CharSequence)configurationId)) {
            QueryWrapper scanCodeEventQueryWrapper = new QueryWrapper();
            scanCodeEventQueryWrapper.eq((Object)"configuration_id", (Object)configurationId);
            List scanCodeEventList = ((ScanCodeEventMapper)this.scanCodeEventRepository.getBaseMapper()).selectList((Wrapper)scanCodeEventQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)scanCodeEventList)) {
                scanCodeEventList.forEach(item -> this.scanCodeExpressionService.deleteByEventId(item.getId()));
                ((ScanCodeEventMapper)this.scanCodeEventRepository.getBaseMapper()).delete((Wrapper)scanCodeEventQueryWrapper);
            }
        }
    }

    private void createValidation(ScanCodeEvent entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getConfigurationId(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u914d\u7f6e\u884cID \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParticipatorFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u626b\u7801\u884c\u4e3a\u4e3b\u4f53(\u5206\u5229\u53c2\u4e0e\u8005 \u6807\u8bb0\uff09 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getParticipatorName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u626b\u7801\u884c\u4e3a\u4e3b\u4f53(\u5206\u5229\u53c2\u4e0e\u8005 \u4e2d\u6587\u540d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getBarCodeTypeFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6761\u7801\u7c7b\u578b\uff08\u7bb1\u3001\u74f6\u3001\u76d6 \u6807\u8bb0\uff09 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getBarCodeTypeName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u6761\u7801\u7c7b\u578b\uff08\u7bb1\u3001\u74f6\u3001\u76d6 \u4e2d\u6587\u540d\uff09 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getParticipatorFlag() == null || entity.getParticipatorFlag().length() < 16 ? 1 : 0) != 0, (String)"\u626b\u7801\u884c\u4e3a\u4e3b\u4f53(\u5206\u5229\u53c2\u4e0e\u8005 \u6807\u8bb0\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getParticipatorName() == null || entity.getParticipatorName().length() < 16 ? 1 : 0) != 0, (String)"\u626b\u7801\u884c\u4e3a\u4e3b\u4f53(\u5206\u5229\u53c2\u4e0e\u8005 \u4e2d\u6587\u540d\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getBarCodeTypeFlag() == null || entity.getBarCodeTypeFlag().length() < 16 ? 1 : 0) != 0, (String)"\u6761\u7801\u7c7b\u578b\uff08\u7bb1\u3001\u74f6\u3001\u76d6 \u6807\u8bb0\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((entity.getBarCodeTypeName() == null || entity.getBarCodeTypeName().length() < 16 ? 1 : 0) != 0, (String)"\u6761\u7801\u7c7b\u578b\uff08\u7bb1\u3001\u74f6\u3001\u76d6 \u4e2d\u6587\u540d\uff09,\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }
}

