package com.biz.crm.cps.business.signtask.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivity;
import com.biz.crm.cps.business.signtask.local.service.SignTaskActivityService;
import com.biz.crm.cps.business.signtask.sdk.dto.SignTaskActivityDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 活动签约任务 Controller
 * @author: rentao
 * @date: 2021/12/23 18:37
 */
@Api(tags = "活动签约任务")
@Slf4j
@RestController
@RequestMapping("/v1/signTaskActivity/signTaskActivity")
public class SignTaskActivityController {

   @Autowired
   private SignTaskActivityService signTaskActivityService;


  /**
   * 根据条件分页查询活动签约任务
   *
   * @param pageable 分页信息
   * @param signTaskActivityDto      包含查询条件的请求
   * @return 活动签约任务列表
   */
  @ApiOperation(value = "多条件分页查询", notes = "queryFlag 查询标记: H5/ADMIN，分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<SignTaskActivity>> findByConditions(@PageableDefault(50) Pageable pageable, @ApiParam(name = "signTaskActivityDto", value = "活动签约任务分页Dto") SignTaskActivityDto signTaskActivityDto) {
    try {
      Page<SignTaskActivity> result = this.signTaskActivityService.findByConditions(pageable, signTaskActivityDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 按照SignTaskActivity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id 主键
   */
  @ApiOperation(value = "按照SignTaskActivity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value = "/findDetailsById", method = {RequestMethod.GET})
  public Result<SignTaskActivity> findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      SignTaskActivity result = this.signTaskActivityService.findDetailsById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 任务签约
   * @return 任务签约
   */
  @ApiOperation(value = "任务签约")
  @PatchMapping
  public Result updateSign(@RequestBody @ApiParam(name="signTaskActivityDto" , value="任务签约") SignTaskActivity signTaskActivity) {
    try {
     this.signTaskActivityService.updateSign(signTaskActivity);
      return Result.ok();
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
