package com.biz.crm.cps.business.signtask.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.signtask.local.entity.SignTask;
import com.biz.crm.cps.business.signtask.local.service.SignTaskService;
import com.biz.crm.cps.business.signtask.sdk.dto.SignTaskDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 活动签约配置
 * @author: rentao
 * @date: 2021/12/20 17:34
 */
@Api(tags = "活动签约配置")
@Slf4j
@RestController
@RequestMapping("/v1/signTask/signTask")
public class SignTaskController {

  @Autowired
  private SignTaskService signTaskService;

  /**
   * 根据条件分页查询签约配置
   *
   * @param pageable 分页信息
   * @param dto      包含查询条件的请求
   * @return 活动签约列表
   */
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;" +
      "可传的参数：signTaskCode 活动签约编码，signTaskName 活动签约名称，permissionType 客户类型，signTaskType 活动类型")
  @GetMapping("findByConditions")
  public Result<Page<SignTask>> findByConditions(@PageableDefault(50) Pageable pageable, @ApiParam(name = "signTaskDto", value = "活动签约分页Dto") SignTaskDto dto) {
    try {
      Page<SignTask> result = this.signTaskService.findByConditions(pageable, dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 按照SignTask实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   *
   * @param id 主键
   */
  @ApiOperation(value = "按照SignTask实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value = "/findDetailsById", method = {RequestMethod.GET})
  public Result<SignTask> findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      SignTask result = this.signTaskService.findDetailsById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据主键id查询协议模板信息(不包含关联信息)
   * @param id 主键id
   * @return 协议模板数据
   */
  @ApiOperation(value = "相关的查询过程，http接口。通过主键进行数据的查询")
  @GetMapping(value="/{id}")
  public Result<SignTask> findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id){
    try {
      SignTask signTask = this.signTaskService.findById(id);
      return Result.ok(signTask);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建活动签约配置
   * @param signTask 活动签约
   * @return 创建活动签约实体
   */
  @ApiOperation(value = "创建活动签约配置")
  @PostMapping(value="")
  public Result<SignTask> create(@RequestBody @ApiParam(name="signTask" , value="创建活动签约配置") SignTask signTask) {
    try {
      SignTask current = this.signTaskService.create(signTask);
      return Result.ok(current);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改活动签约配置
   * @return 修改活动签约配置
   */
  @ApiOperation(value = "修改活动签约配置")
  @PatchMapping
  public Result<SignTask> update(@RequestBody @ApiParam(name="signTask" , value="修改活动签约配置") SignTask signTask) {
    try {
      SignTask current = this.signTaskService.update(signTask);
      return Result.ok(current);
    } catch(RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.signTaskService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.signTaskService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
