package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @description: 签收活动与渠道关联表
 * @author: rentao
 * @date: 2021/12/20 16:35
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskChannelRelationship", description = "签收活动与渠道关联表")
@TableName("sign_task_channel_relationship")
public class SignTaskChannelRelationship extends BaseIdEntity {
  private static final long serialVersionUID = -6177464611562548443L;

  /**
   * 签收活动编码
   */
  @Column(name = "sign_task_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收活动编码 '")
  @ApiModelProperty("签收活动编码")
  @TableField(value = "sign_task_code")
  private String signTaskCode;

  /**
   * 所属渠道编码
   */
  @Column(name = "channel_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属渠道编码 '")
  @ApiModelProperty("所属渠道编码")
  @TableField(value = "channel_code")
  private String channelCode;

  /**
   * 所属渠道名称
   */
  @Column(name = "channel_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属渠道名称 '")
  @ApiModelProperty("所属渠道名称")
  @TableField(value = "channel_name")
  private String channelName;
}
