package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @description: 签收活动与物料关联表
 * @author: rentao
 * @date: 2021/12/21 10:35
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskMaterialRelationship", description = "签收活动与物料关联表")
@TableName("sign_task_material_relationship")
public class SignTaskMaterialRelationship extends BaseIdEntity {
  private static final long serialVersionUID = -6177464611562548443L;

  /**
   * 签收活动编码
   */
  @Column(name = "sign_task_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收活动编码 '")
  @ApiModelProperty("签收活动编码")
  @TableField(value = "sign_task_code")
  private String signTaskCode;

  /**
   * 物料编码
   */
  @Column(name = "material_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料编码 '")
  @ApiModelProperty("物料编码")
  @TableField(value = "material_code")
  private String materialCode;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  @Column(name = "material_name",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 物料名称 '")
  @TableField(value = "material_name")
  private String materialName;

  /**
   * 物料类型
   */
  @ApiModelProperty("物料类型")
  @Column(name = "material_type",nullable = false, length = 10, columnDefinition = "VARCHAR(10) COMMENT ' 物料类型 '")
  @TableField(value = "material_type")
  private String materialType;

  /**
   * 商品图片
   */
  @ApiModelProperty("商品图片")
  @Column(name = "img_url",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 商品图片 '")
  @TableField(value = "img_url")
  private String imgUrl;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  @Column(name = "sale_unit",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 销售单位 '")
  @TableField(value = "sale_unit")
  private String saleUnit;

  /**
   * 数量
   */
  @ApiModelProperty("数量")
  @Column(name = "quantity", columnDefinition = "decimal(20,4) COMMENT '数量'")
  @TableField(value = "quantity")
  private BigDecimal quantity;

}
