package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @description: 签收活动与组织关联表
 * @author: rentao
 * @date: 2021/12/20 16:28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskOrgRelationship", description = "签收活动与组织关联表")
@TableName("sign_task_org_relationship")
public class SignTaskOrgRelationship extends BaseIdEntity {
  private static final long serialVersionUID = 2398248965094366388L;


  /**
   * 签收活动编码
   */
  @Column(name = "sign_task_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收活动编码 '")
  @ApiModelProperty("签收活动编码")
  @TableField(value = "sign_task_code")
  private String signTaskCode;

  /**
   * 所属组织编码
   */
  @Column(name = "org_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  @ApiModelProperty("所属组织编码")
  @TableField(value = "org_code")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @Column(name = "org_name",nullable = false, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属组织名称 '")
  @ApiModelProperty("所属组织名称")
  @TableField(value = "org_name")
  private String orgName;

}
