package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @description: 签收活动标签关联表
 * @author: rentao
 * @date: 2021/12/20 16:32
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskTagRelationship", description = "签收活动标签关联表")
@TableName("sign_task_tag_relationship")
public class SignTaskTagRelationship extends BaseIdEntity {
  private static final long serialVersionUID = 3215263300714554548L;
  /**
   * 签收活动编码
   */
  @Column(name = "sign_task_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收活动编码 '")
  @ApiModelProperty("签收活动编码")
  @TableField(value = "sign_task_code")
  private String SignTaskCode;

  /**
   * 标签
   */
  @Column(name = "tag",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 分利模板包含标签 '")
  @ApiModelProperty("标签")
  @TableField(value = "tag")
  private String tag;

}
