package com.biz.crm.cps.business.signtask.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @description: 签收活动与指定终端关联表
 * @author: rentao
 * @date: 2021/12/20 16:28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SignTaskTerminalRelationship", description = "签收活动与指定终端关联表")
@TableName("sign_task_terminal_relationship")
public class SignTaskTerminalRelationship extends BaseIdEntity {

  /**
   * 签收活动编码
   */
  @Column(name = "sign_task_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 签收活动编码 '")
  @ApiModelProperty("签收活动编码")
  @TableField(value = "sign_task_code")
  private String signTaskCode;

  /**
   * 指定终端编码
   */
  @Column(name = "terminal_code",nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 指定终端编码 '")
  @ApiModelProperty("指定终端编码")
  @TableField(value = "terminal_code")
  private String terminalCode;

  /**
   * 指定终端编码
   */
  @Column(name = "terminal_name",length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 指定终端名称 '")
  @ApiModelProperty("指定终端名称")
  @TableField(value = "terminal_name")
  private String terminalName;

  /**
   * 指定终端标签
   */
  @Column(name = "tag_description", columnDefinition = "VARCHAR(255) COMMENT ' 指定终端标签 '")
  @ApiModelProperty("指定终端标签")
  @TableField(value = "tag_description")
  private String tagDescription;

  /**
   * 指定终端类型
   */
  @Column(name = "terminal_type", columnDefinition = "VARCHAR(64) COMMENT ' 指定终端类型 '")
  @ApiModelProperty("指定终端类型")
  @TableField(value = "terminal_type")
  private String terminalType;

  /**
   * 所属组织编码
   */
  @Column(name = "organization_code", columnDefinition = "VARCHAR(64) COMMENT ' 所属组织编码 '")
  @ApiModelProperty("所属组织编码")
  @TableField(value = "organization_code")
  private String organizationCode;

  /**
   * 所属组织
   */
  @Column(name = "organization", columnDefinition = "VARCHAR(64) COMMENT ' 所属组织 '")
  @ApiModelProperty("所属组织")
  @TableField(value = "organization")
  private String organization;

  /**
   * 所属客户组织
   */
  @Column(name = "customer_organization", columnDefinition = "VARCHAR(64) COMMENT ' 所属客户组织 '")
  @ApiModelProperty("所属客户组织")
  @TableField(value = "customer_organization")
  private String customerOrganization;

  /**
   * 所属客户组织编码
   */
  @Column(name = "customer_organization_code", columnDefinition = "VARCHAR(64) COMMENT ' 所属客户组织编码 '")
  @ApiModelProperty("所属客户组织编码")
  @TableField(value = "customer_organization_code")
  private String customerOrganizationCode;

  /**
   * 所属渠道
   */
  @Column(name = "channel_code", columnDefinition = "VARCHAR(64) COMMENT ' 所属渠道 '")
  @ApiModelProperty("所属渠道")
  @TableField(value = "channel_code")
  private String channelCode;

  /**
   * 所属渠道名称
   */
  @Column(name = "channel_name", columnDefinition = "VARCHAR(64) COMMENT ' 所属渠道名称 '")
  @ApiModelProperty("所属渠道名称")
  @TableField(value = "channel_name")
  private String channelName;



}
