package com.biz.crm.cps.business.signtask.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivityDetail;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivityPicture;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskChannelRelationship;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskActivityDetailMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 活动签约任务明细
 * @author: rentao
 * @date: 2021/12/23 21:00
 */
@Component
public class SignTaskActivityDetailRepository extends
    ServiceImpl<SignTaskActivityDetailMapper, SignTaskActivityDetail> {

  /**
   * 根据活动签约任务编码删除关联信息
   *
   * @param signTaskActivityCodes
   */
  public void deleteBySignTaskActivityCodes(List<String> signTaskActivityCodes) {
    this.lambdaUpdate().in(SignTaskActivityDetail::getSignTaskActivityCode, signTaskActivityCodes)
        .remove();
  }

  /**
   * 根据活动签约任务编码查询关联信息
   *
   * @param signTaskActivityCode
   */
  public List<SignTaskActivityDetail> findBySignTaskActivityCode(String signTaskActivityCode) {
    return  this.lambdaQuery()
        .eq(SignTaskActivityDetail::getSignTaskActivityCode, signTaskActivityCode)
        .list();
  }
}
