package com.biz.crm.cps.business.signtask.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivityDetail;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivityPicture;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskTagRelationship;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskActivityPictureMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 活动签约任务照片
 * @author: rentao
 * @date: 2021/12/23 21:04
 */
@Component
public class SignTaskActivityPictureRepository extends
    ServiceImpl<SignTaskActivityPictureMapper, SignTaskActivityPicture> {

  /**
   * 根据活动签约任务编码删除关联信息
   * @param signTaskActivityCode
   */
  public void deleteBySignTaskActivityCode(String signTaskActivityCode) {
    this.lambdaUpdate().eq(SignTaskActivityPicture::getSignTaskActivityCode, signTaskActivityCode).remove();
  }

  /**
   * 根据活动签约任务编码查询关联信息
   *
   * @param signTaskActivityCode
   */
  public List<SignTaskActivityPicture> findBySignTaskActivityCode(String signTaskActivityCode) {
    return this.lambdaQuery()
        .eq(SignTaskActivityPicture::getSignTaskActivityCode, signTaskActivityCode)
        .list();
  }
}
