package com.biz.crm.cps.business.signtask.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskChannelRelationship;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskOrgRelationship;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskTagRelationship;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskChannelRelationshipMapper;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskOrgRelationshipMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 活动签约配置关联组织
 * @author: rentao
 * @date: 2021/12/20 19:06
 */
@Component
public class SignTaskOrgRelationshipRepository extends
    ServiceImpl<SignTaskOrgRelationshipMapper, SignTaskOrgRelationship> {

  /**
   * 根据活动签约编码删除关联信息
   * @param signTaskCode
   */
  public void deleteBySignTaskCode(String signTaskCode) {
    this.lambdaUpdate().eq(SignTaskOrgRelationship::getSignTaskCode, signTaskCode).remove();
  }

  /**
   * 根据活动签约编码查询关联信息
   * @param signTaskCode
   */
  public List<SignTaskOrgRelationship> findBySignTaskCode(String signTaskCode){
    return this.lambdaQuery()
        .eq(SignTaskOrgRelationship::getSignTaskCode, signTaskCode).list();
  }
}
