package com.biz.crm.cps.business.signtask.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskTagRelationship;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskTagRelationship;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskTagRelationshipMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 活动签约配置关联标签
 * @author: rentao
 * @date: 2021/12/20 19:06
 */
@Component
public class SignTaskTagRelationshipRepository extends
    ServiceImpl<SignTaskTagRelationshipMapper, SignTaskTagRelationship> {


  /**
   * 根据活动签约配置编码删除关联信息
   * @param signTaskCode
   */
  public void deleteBySignTaskCode(String signTaskCode) {
    this.lambdaUpdate().eq(SignTaskTagRelationship::getSignTaskCode, signTaskCode).remove();
  }

  /**
   * 根据活动签约编码查询关联信息
   * @param signTaskCode
   */
  public List<SignTaskTagRelationship> findBySignTaskCode(String signTaskCode){
    return this.lambdaQuery()
        .eq(SignTaskTagRelationship::getSignTaskCode, signTaskCode).list();
  }
}
