package com.biz.crm.cps.business.signtask.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskTagRelationship;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskTerminalRelationship;
import com.biz.crm.cps.business.signtask.local.mapper.SignTaskTerminalRelationshipMapper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 活动签约配置关联终端
 * @author: rentao
 * @date: 2021/12/20 19:06
 */
@Component
public class SignTaskTerminalRelationshipRepository extends
    ServiceImpl<SignTaskTerminalRelationshipMapper, SignTaskTerminalRelationship> {


  /**
   * 根据活动签约配置编码删除关联信息
   * @param signTaskCode
   */
  public void deleteBySignTaskCode(String signTaskCode) {
    this.lambdaUpdate().eq(SignTaskTerminalRelationship::getSignTaskCode, signTaskCode).remove();
  }

  /**
   * 根据活动签约编码查询关联信息
   * @param signTaskCode
   */
  public List<SignTaskTerminalRelationship> findBySignTaskCode(String signTaskCode){
    return this.lambdaQuery()
        .eq(SignTaskTerminalRelationship::getSignTaskCode, signTaskCode).list();
  }
}
