package com.biz.crm.cps.business.signtask.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivity;
import com.biz.crm.cps.business.signtask.sdk.dto.SignTaskActivityDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @description: 活动签收任务主表
 * @author: rentao
 * @date: 2021/12/23 17:25
 */
public interface SignTaskActivityService {

  /**
   * 分页条件查询活动签收任务
   * @param pageable 分页信息
   * @param signTaskActivityDto 分页查询dto
   * @return 分页返回信息
   */
  Page<SignTaskActivity> findByConditions(Pageable pageable, SignTaskActivityDto signTaskActivityDto);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   * @return 活动签收任务
   */
  SignTaskActivity findDetailsById(String id);


  /**
   * 按照签约配置编码查询(不包含明细)
   *
   * @param signTaskCodes
   * @return 活动签收任务
   */
  List<SignTaskActivity> findBySignTaskCodes(List<String> signTaskCodes);

  /**
   * 签约
   * @param signTaskActivity 签约
   * @return
   */
  void updateSign(SignTaskActivity signTaskActivity);

  /**
   * 活动签收任务新增
   *
   * @param signTaskActivity
   * @author rentao
   * @date
   */
  SignTaskActivity create(SignTaskActivity signTaskActivity);

  /**
   * 活动签收批量任务新增
   *
   * @param signTaskActivitys
   * @author rentao
   * @date
   */
  void createBatch(List<SignTaskActivity> signTaskActivitys);

  /**
   * 通过id删除签约任务
   *
   * @param  signTaskActivities 活动任务集合
   * @author rentao
   * @date
   */
  void deleteBatch(List<SignTaskActivity> signTaskActivities);

  /**
   * 触发活动签约任务方法(定时器)
   * step1:过期结束时间为前一天的活动签约任务
   * @author rentao
   */
  void handleSignTaskActivity();

  /**
   * 批量启用
   *
   * @param ids 主键列表
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用
   *
   * @param ids 主键列表
   */
  void disableBatch(List<String> ids);

}
