package com.biz.crm.cps.business.signtask.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.signtask.local.entity.SignTask;
import com.biz.crm.cps.business.signtask.sdk.dto.SignTaskDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * @description: 签约任务配置 service
 * @author: rentao
 * @date: 2021/12/20 17:38
 */
public interface SignTaskService {

  /**
   * 分页条件查询签约任务配置
   * @param pageable 分页信息
   * @param signTaskDto 分页查询dto
   * @return 分页返回信息
   */
  Page<SignTask> findByConditions(Pageable pageable, SignTaskDto signTaskDto);

  /**
   * 签约任务配置新增
   *
   * @param signTask
   * @author rentao
   * @date
   */
  SignTask create(SignTask signTask);

  /**
   * 签约任务配置编辑
   *
   * @param signTask
   * @author rentao
   * @date
   */
  SignTask update(SignTask signTask);

  /**
   * 根据id查询协议模板数据(不包括关联信息)
   *
   * @param id 协议模板id
   * @return 协议模板实体
   */
  SignTask findById(String id);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   * @return 协议模板实体
   */
  SignTask findDetailsById(String id);

  /**
   * 批量启用
   *
   * @param ids 主键列表
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用
   *
   * @param ids 主键列表
   */
  void disableBatch(List<String> ids);
}
