package com.biz.crm.cps.business.signtask.local.service.notifier;

import com.biz.crm.cps.business.participator.sdk.dto.DealerDto;
import com.biz.crm.cps.business.participator.sdk.dto.TerminalDto;
import com.biz.crm.cps.business.participator.sdk.service.DealerVoService;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.business.signtask.local.config.SignTaskConfig;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivity;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivityDetail;
import com.biz.crm.cps.business.signtask.local.service.SignTaskActivityService;
import com.biz.crm.cps.business.signtask.local.utils.SignTaskActivityUtils;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTaskActivityTypeEnum;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTaskStatusEnum;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTaskTypeEnum;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTypeEnum;
import com.biz.crm.cps.business.signtask.sdk.event.SignTaskEventListener;
import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskChannelRelationshipVo;
import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskCusRelationshipVo;
import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskMaterialRelationshipVo;
import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskOrgRelationshipVo;
import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskTagRelationshipVo;
import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskTerminalRelationshipVo;
import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * @description: 活动签约配置通知实现
 * @author: rentao
 * @date: 2021/12/28 11:22
 */
@Component
public class SignTaskEventListenerImpl implements SignTaskEventListener {

  @Autowired
  private SignTaskActivityService signTaskActivityService;
  @Autowired
  private DealerVoService dealerVoService;
  @Autowired
  private TerminalVoService terminalVoService;
  @Autowired
  private SignTaskConfig signTaskConfig;

  private static final String SALE_UNIT = "元";

  @Override
  @Transactional
  public void onDisable(List<SignTaskVo> signTaskVos) {
    List<String> signTaskCodes = signTaskVos.stream().map(SignTaskVo::getSignTaskCode)
        .collect(Collectors.toList());
    List<SignTaskActivity> signTaskActivitiesOld = signTaskActivityService
        .findBySignTaskCodes(signTaskCodes);
    if(CollectionUtils.isEmpty(signTaskActivitiesOld)){
      return;
    }
    List<String> ids = signTaskActivitiesOld.stream().map(SignTaskActivity::getId)
        .collect(Collectors.toList());
    signTaskActivityService.disableBatch(ids);
  }

  @Override
  @Transactional
  public void onEnable(List<SignTaskVo> signTaskVos) {
    List<String> signTaskCodes = signTaskVos.stream().map(SignTaskVo::getSignTaskCode)
        .collect(Collectors.toList());
    List<SignTaskActivity> signTaskActivitiesOld = signTaskActivityService
        .findBySignTaskCodes(signTaskCodes);
    if(CollectionUtils.isEmpty(signTaskActivitiesOld)){
      return;
    }
    List<String> ids = signTaskActivitiesOld.stream().map(SignTaskActivity::getId)
        .collect(Collectors.toList());
    signTaskActivityService.enableBatch(ids);
  }

  @Override
  @Transactional
  public void onUpdate(SignTaskVo signTaskVo) {
    /**
     * 活动签约编码查询活动签约任务
     * 批量删除活动签约任务
     * 新增任务
     * */
    String signTaskCode = signTaskVo.getSignTaskCode();
    List<SignTaskActivity> signTaskActivitiesOld = signTaskActivityService
        .findBySignTaskCodes(Collections.singletonList(signTaskCode));
    if (!CollectionUtils.isEmpty(signTaskActivitiesOld)) {
      signTaskActivityService.deleteBatch(signTaskActivitiesOld);
    }
    List<SignTaskActivity> signTaskActivities = this.buildSignTaskActivity(signTaskVo);
    this.signTaskActivityService.createBatch(signTaskActivities);
  }

  @Override
  @Transactional
  public void onCreate(SignTaskVo signTaskVo) {
    /**
     * 组装活动签约任务
     * 批量保存
     *
     * */
    List<SignTaskActivity> signTaskActivities = this.buildSignTaskActivity(signTaskVo);

    this.signTaskActivityService.createBatch(signTaskActivities);
  }

  /**
   * 签约配置转换称 活动签约任务集合
   *
   * @param signTaskVo 签约配置
   */
  private List<SignTaskActivity> buildSignTaskActivity(SignTaskVo signTaskVo) {
    SignTypeEnum signTypeEnum = SignTypeEnum.getByKey(signTaskVo.getSignType());
    Set<DealerVo> dealerVoSet = null;
    Set<TerminalVo> terminalVoSet = null;
    if (SignTypeEnum.CUS.getKey().equals(signTypeEnum.getKey())) {
      dealerVoSet = this.getDealerVo(signTaskVo);
    }
    if (SignTypeEnum.TERMINAL.getKey().equals(signTypeEnum.getKey())) {
      terminalVoSet = this.getTerminalVo(signTaskVo);
    }
    if (terminalVoSet != null) {
      return this.buildSignTaskActivityTerminal(terminalVoSet, signTaskVo);
    }
    if (dealerVoSet != null) {
      return this.buildSignTaskActivityDealer(dealerVoSet, signTaskVo);
    }
    return null;
  }

  /**
   * 获取所有可用终端
   *
   * @param signTaskVo
   * @author rentao
   * @date
   */
  private Set<TerminalVo> getTerminalVo(SignTaskVo signTaskVo) {
    TerminalDto terminalDto = new TerminalDto();
    Set<SignTaskOrgRelationshipVo> signTaskOrgRelationships = signTaskVo
        .getSignTaskOrgRelationships();
    if (!CollectionUtils.isEmpty(signTaskOrgRelationships)) {
      List<String> collect = signTaskOrgRelationships.stream()
          .map(SignTaskOrgRelationshipVo::getOrgCode).collect(Collectors.toList());
      terminalDto.setOrgCodes(collect);
    }
    Set<SignTaskTagRelationshipVo> signTaskTagRelationships = signTaskVo
        .getSignTaskTagRelationships();
    if (!CollectionUtils.isEmpty(signTaskTagRelationships)) {
      List<String> collect = signTaskTagRelationships.stream()
          .map(SignTaskTagRelationshipVo::getTag).collect(Collectors.toList());
      terminalDto.setTagDescriptions(collect);
    }
    Set<SignTaskChannelRelationshipVo> signTaskChannelRelationships = signTaskVo
        .getSignTaskChannelRelationships();
    if (!CollectionUtils.isEmpty(signTaskChannelRelationships)) {
      List<String> collect = signTaskChannelRelationships.stream()
          .map(SignTaskChannelRelationshipVo::getChannelCode).collect(Collectors.toList());
      terminalDto.setChannelCodes(collect);
    }
    Set<SignTaskTerminalRelationshipVo> signTaskTerminalRelationships = signTaskVo
        .getSignTaskTerminalRelationships();
    if (!CollectionUtils.isEmpty(signTaskTerminalRelationships)) {
      List<String> terminalCodes = signTaskTerminalRelationships.stream()
          .map(SignTaskTerminalRelationshipVo::getTerminalCode).collect(
              Collectors.toList());
      List<TerminalVo> terminalVos = terminalVoService.findByTerminalCodes(terminalCodes);
      Validate.isTrue(!CollectionUtils.isEmpty(terminalVos), "选择终端信息不存在!");
      Set<TerminalVo> terminalVoSet = new HashSet();
      terminalVos.forEach(terminalVo -> {
        terminalVoSet.add(terminalVo);
      });
      return terminalVoSet;
    }
    return this.terminalVoService.findByConditions(terminalDto);
  }

  /**
   * 获取所有可用客户
   *
   * @param signTaskVo
   * @author rentao
   * @date
   */
  private Set<DealerVo> getDealerVo(SignTaskVo signTaskVo) {
    DealerDto dealerDto = new DealerDto();
    Set<SignTaskOrgRelationshipVo> signTaskOrgRelationships = signTaskVo
        .getSignTaskOrgRelationships();
    if (!CollectionUtils.isEmpty(signTaskOrgRelationships)) {
      List<String> collect = signTaskOrgRelationships.stream()
          .map(SignTaskOrgRelationshipVo::getOrgCode).collect(Collectors.toList());
      dealerDto.setOrgCodes(collect);
    }
    Set<SignTaskTagRelationshipVo> signTaskTagRelationships = signTaskVo
        .getSignTaskTagRelationships();
    if (!CollectionUtils.isEmpty(signTaskTagRelationships)) {
      List<String> collect = signTaskTagRelationships.stream()
          .map(SignTaskTagRelationshipVo::getTag).collect(Collectors.toList());
      dealerDto.setTagDescriptions(collect);
    }
    Set<SignTaskChannelRelationshipVo> signTaskChannelRelationships = signTaskVo
        .getSignTaskChannelRelationships();
    if (!CollectionUtils.isEmpty(signTaskChannelRelationships)) {
      List<String> collect = signTaskChannelRelationships.stream()
          .map(SignTaskChannelRelationshipVo::getChannelCode).collect(Collectors.toList());
      dealerDto.setChannelCodes(collect);
    }
    Set<SignTaskCusRelationshipVo> signTaskTerminalRelationships = signTaskVo
        .getSignTaskCusRelationships();
    //全部客户
    if (!CollectionUtils.isEmpty(signTaskTerminalRelationships)) {
      List<String> cusCodes = signTaskTerminalRelationships.stream()
          .map(SignTaskCusRelationshipVo::getCustomerCode).collect(
              Collectors.toList());
      List<DealerVo> dealerVos = dealerVoService.findByCustomerCodes(cusCodes);
      Validate.isTrue(!CollectionUtils.isEmpty(dealerVos), "选择客户信息不存在!");
      Set<DealerVo> dealerVoSet = new HashSet();
      dealerVos.forEach(dealerVo->{
        dealerVoSet.add(dealerVo);
      });
      return dealerVoSet;
    }
    return this.dealerVoService.findByConditions(dealerDto);
  }


  /**
   * 终端转换活动签约任务集合
   *
   * @param terminalVoSet 终端集合
   * @param signTaskVo    签约任务配置
   * @author rentao
   * @date
   */
  private List<SignTaskActivity> buildSignTaskActivityTerminal(Set<TerminalVo> terminalVoSet,
      SignTaskVo signTaskVo) {
    if (terminalVoSet != null) {
      List<SignTaskActivity> list = new ArrayList<>();
      terminalVoSet.forEach(terminalVo -> {
        SignTaskActivity signTaskActivity = new SignTaskActivity();
        signTaskActivity.setSignTaskCode(signTaskVo.getSignTaskCode());
        signTaskActivity.setSignTaskName(signTaskVo.getSignTaskName());
        signTaskActivity.setSignTaskActivityType(SignTaskActivityTypeEnum.SIGN_ACTIVITY.getKey());
        signTaskActivity.setClientClassify(signTaskVo.getSignType());
        signTaskActivity.setClientOrgCode(terminalVo.getCustomerOrganizationCode());
        signTaskActivity.setClientOrgName(terminalVo.getCustomerOrganization());
        signTaskActivity.setOrgCode(terminalVo.getOrganizationCode());
        signTaskActivity.setOrgName(terminalVo.getOrganization());
        signTaskActivity.setClientName(terminalVo.getTerminalName());
        signTaskActivity.setClientCode(terminalVo.getTerminalCode());
        signTaskActivity.setPhotograph(signTaskVo.getPhotograph());
        signTaskActivity.setSignTaskStartTime(signTaskVo.getSignTaskStartTime());
        signTaskActivity.setSignTaskEndTime(signTaskVo.getSignTaskEndTime());
        signTaskActivity.setSignTaskStatus(SignTaskStatusEnum.STATUS_WAIT.getKey());
        signTaskActivity.setClientType(terminalVo.getTerminalType());
        signTaskActivity.setTagName(terminalVo.getTagDescription());
        signTaskActivity.setEnableStatus(signTaskVo.getEnableStatus());
        signTaskActivity.setChannelCode(terminalVo.getChannel());
        if (SignTaskTypeEnum.MATTER.getKey().equals(signTaskVo.getSignTaskType())) {
          Set<SignTaskMaterialRelationshipVo> signTaskMaterialRelationships = signTaskVo
              .getSignTaskMaterialRelationships();
          List<SignTaskActivityDetail> signTaskActivityDetails = new ArrayList<>();
          signTaskMaterialRelationships.forEach(signTaskMaterialRelationship -> {
            SignTaskActivityDetail signTaskActivityDetail = new SignTaskActivityDetail();
            signTaskActivityDetail
                .setSignResourceCode(signTaskMaterialRelationship.getMaterialCode());
            signTaskActivityDetail
                .setSignResourceName(signTaskMaterialRelationship.getMaterialName());
            signTaskActivityDetail.setUrlPath(signTaskMaterialRelationship.getImgUrl());
            signTaskActivityDetail.setSaleUnit(signTaskMaterialRelationship.getSaleUnit());
            signTaskActivityDetail.setQuantity(signTaskMaterialRelationship.getQuantity());
            signTaskActivityDetails.add(signTaskActivityDetail);
          });
          signTaskActivity.setSignTaskActivityDetails(signTaskActivityDetails);
        }
        if (SignTaskTypeEnum.CASH.getKey().equals(signTaskVo.getSignTaskType())) {
          SignTaskActivityDetail signTaskActivityDetail = new SignTaskActivityDetail();
          signTaskActivityDetail.setSignResourceCode(SignTaskTypeEnum.CASH.getDictCode());
          signTaskActivityDetail.setSignResourceName(SignTaskTypeEnum.CASH.getValue());
          signTaskActivityDetail.setSaleUnit(SALE_UNIT);
          signTaskActivityDetail.setUrlPath(signTaskConfig.getImgUrl());
          signTaskActivityDetail.setQuantity(signTaskVo.getSignTaskAmount());
          signTaskActivity
              .setSignTaskActivityDetails(Collections.singletonList(signTaskActivityDetail));
        }
        list.add(signTaskActivity);
      });
      return list;
    }
    return null;
  }

  /**
   * 经销商转换活动签约任务集合
   *
   * @param dealerVoSet 经销商集合
   * @param signTaskVo  签约任务配置
   * @author rentao
   * @date
   */
  private List<SignTaskActivity> buildSignTaskActivityDealer(Set<DealerVo> dealerVoSet,
      SignTaskVo signTaskVo) {
    if (dealerVoSet != null) {
      List<SignTaskActivity> list = new ArrayList<>();
      dealerVoSet.forEach(dealerVo -> {
        SignTaskActivity signTaskActivity = new SignTaskActivity();
        signTaskActivity.setSignTaskCode(signTaskVo.getSignTaskCode());
        signTaskActivity.setSignTaskName(signTaskVo.getSignTaskName());
        signTaskActivity.setSignTaskActivityType(SignTaskActivityTypeEnum.SIGN_ACTIVITY.getKey());
        signTaskActivity.setClientClassify(signTaskVo.getSignType());
        signTaskActivity.setClientOrgCode(dealerVo.getCustomerOrgCode());
        signTaskActivity.setClientOrgName(dealerVo.getCustomerOrgName());
        signTaskActivity.setOrgCode(dealerVo.getOrgCode());
        signTaskActivity.setOrgName(dealerVo.getOrgName());
        signTaskActivity.setEnableStatus(signTaskVo.getEnableStatus());
        signTaskActivity.setClientName(dealerVo.getCustomerName());
        signTaskActivity.setClientCode(dealerVo.getCustomerCode());
        signTaskActivity.setPhotograph(signTaskVo.getPhotograph());
        signTaskActivity.setSignTaskStartTime(signTaskVo.getSignTaskStartTime());
        signTaskActivity.setSignTaskEndTime(signTaskVo.getSignTaskEndTime());
        signTaskActivity.setSignTaskStatus(SignTaskStatusEnum.STATUS_WAIT.getKey());
        signTaskActivity.setClientType(dealerVo.getCustomerType());
        signTaskActivity.setTagName(dealerVo.getTagDescription());
        signTaskActivity.setChannelCode(dealerVo.getChannelCode());
        signTaskActivity.setChannelName(dealerVo.getChannelName());
        if (SignTaskTypeEnum.MATTER.getKey().equals(signTaskVo.getSignTaskType())) {
          Set<SignTaskMaterialRelationshipVo> signTaskMaterialRelationships = signTaskVo
              .getSignTaskMaterialRelationships();
          List<SignTaskActivityDetail> signTaskActivityDetails = new ArrayList<>();
          signTaskMaterialRelationships.forEach(signTaskMaterialRelationship -> {
            SignTaskActivityDetail signTaskActivityDetail = new SignTaskActivityDetail();
            signTaskActivityDetail
                .setSignResourceCode(signTaskMaterialRelationship.getMaterialCode());
            signTaskActivityDetail
                .setSignResourceName(signTaskMaterialRelationship.getMaterialName());
            signTaskActivityDetail.setUrlPath(signTaskMaterialRelationship.getImgUrl());
            signTaskActivityDetail.setQuantity(signTaskMaterialRelationship.getQuantity());
            signTaskActivityDetails.add(signTaskActivityDetail);
          });
          signTaskActivity.setSignTaskActivityDetails(signTaskActivityDetails);
        }
        if (SignTaskTypeEnum.CASH.getKey().equals(signTaskVo.getSignTaskType())) {
          SignTaskActivityDetail signTaskActivityDetail = new SignTaskActivityDetail();
          signTaskActivityDetail.setSignResourceCode(SignTaskTypeEnum.CASH.getDictCode());
          signTaskActivityDetail.setSignResourceName(SignTaskTypeEnum.CASH.getValue());
          signTaskActivityDetail.setSaleUnit(SALE_UNIT);
          signTaskActivityDetail.setUrlPath(signTaskConfig.getImgUrl());
          signTaskActivityDetail.setQuantity(signTaskVo.getSignTaskAmount());
          signTaskActivity
              .setSignTaskActivityDetails(Collections.singletonList(signTaskActivityDetail));
        }
        list.add(signTaskActivity);
      });
      return list;
    }
    return null;
  }

}
