package com.biz.crm.cps.business.signtask.local.utils;

import com.biz.crm.cps.business.participator.sdk.vo.DealerVo;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.business.signtask.local.entity.SignTask;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivity;
import com.biz.crm.cps.business.signtask.local.entity.SignTaskActivityDetail;
import com.biz.crm.cps.business.signtask.sdk.enums.PermissionTypeEnum;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTaskActivityTypeEnum;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTaskStatusEnum;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTaskTypeEnum;
import com.biz.crm.cps.business.signtask.sdk.enums.SignTypeEnum;
import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskMaterialRelationshipVo;
import com.biz.crm.cps.business.signtask.sdk.vo.SignTaskVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

/**
 * @description: 签约配置工具类
 * @author: rentao
 * @date: 2021/12/28 10:44
 */
public class SignTaskActivityUtils {





  /**
   * 编辑验证
   *
   * @param signTask 签约配置
   */
  public static void updateValidation(SignTask signTask) {
    Validate.notNull(signTask.getId(), "做数据操作时，信息的数据编号（主键）不能为空!");
    baseValidation(signTask);
    Validate.notBlank(signTask.getSignTaskCode(), "做数据操作时，签收活动编码不能为空！");

  }

  /**
   * 创建验证
   *
   * @param signTask 签约配置
   */
  public static void createValidation(SignTask signTask) {
    Validate.isTrue(StringUtils.isBlank(signTask.getId()), "添加信息时，当期信息的数据编号（主键）不能有值！");
    baseValidation(signTask);
    signTask.setId(null);

  }

  /**
   * 签约活动任务 基础验证
   *
   * @param signTask
   * @author rentao
   * @date
   */
  public static void baseValidation(SignTask signTask) {
    Validate.notBlank(signTask.getSignTaskName(), "做数据操作时，签收活动名称不能为空！");
    Validate.notNull(signTask.getSignTaskStartTime(), "做数据操作时，生效开始时间不能为空！");
    Validate.notNull(signTask.getSignTaskEndTime(), "做数据操作时，生效结束时间不能为空！");
    Validate.notNull(signTask.getPermissionType(), "做数据操作时，权限类型不能为空！");
    Validate.notNull(signTask.getSignTaskType(), "做数据操作时，活动类型不能为空！");
    Validate.notNull(signTask.getSignType(), "做数据操作时，签约客户类型不能为空！");
    Validate.notNull(signTask.getEnableStatus(), "做数据操作时，启用禁用不能为空！");
    Validate.notNull(PermissionTypeEnum.getByKey(signTask.getPermissionType()), "做数据操作时，权限类型不存在！");
    Validate.notNull(SignTaskTypeEnum.getByKey(signTask.getSignTaskType()), "做数据操作时，活动类型不存在！");
    Validate.notNull(SignTypeEnum.getByKey(signTask.getSignType()), "做数据操作时，签约客户类型不存在！");
    if (signTask.getSignTaskType().equals(SignTaskTypeEnum.MATTER.getKey())) {
      Validate.isTrue(!CollectionUtils.isEmpty(signTask.getSignTaskMaterialRelationships()),
          "活动类型为实物时必须选物料");
      signTask.getSignTaskMaterialRelationships().forEach(signTaskMaterialRelationship -> {
        Validate.notNull(signTaskMaterialRelationship.getQuantity(), "物料数量不能为空");
        Validate.isTrue(signTaskMaterialRelationship.getQuantity().compareTo(BigDecimal.ZERO) > 0,
            "数量不能小于0");
      });
    }
    if (signTask.getSignTaskType().equals(SignTaskTypeEnum.CASH.getKey())) {
      Validate.notNull(signTask.getSignTaskAmount(), "活动类型为现金时必须填金额");
      signTask.setSignTaskMaterialRelationships(null);
    }
    if (signTask.getSignType().equals(SignTypeEnum.TERMINAL.getKey())) {
      signTask.setSignTaskCusRelationships(null);
    }
    if (signTask.getSignType().equals(SignTypeEnum.CUS.getKey())) {
      signTask.setSignTaskTerminalRelationships(null);
    }
    //如果是 0全部终端门店，1部分终端门店，2指定终端门店
    if (PermissionTypeEnum.ALL_TERMINAL.getKey().equals(signTask.getPermissionType())) {
      //清空所有
      signTask.setSignTaskCusRelationships(null);
      signTask.setSignTaskTerminalRelationships(null);
      signTask.setSignTaskOrgRelationships(null);
      signTask.setSignTaskChannelRelationships(null);
      signTask.setSignTaskTagRelationships(null);
    }
    if (PermissionTypeEnum.APPOINT_TERMINAL.getKey().equals(signTask.getPermissionType())) {
      //指定清楚 组织 渠道 标签
      signTask.setSignTaskOrgRelationships(null);
      signTask.setSignTaskChannelRelationships(null);
      signTask.setSignTaskTagRelationships(null);
      Validate.isTrue(
          (!CollectionUtils.isEmpty(signTask.getSignTaskCusRelationships()) || !CollectionUtils
              .isEmpty(signTask.getSignTaskTerminalRelationships())), "指定终端/客户必须传值");
    }

    if (PermissionTypeEnum.PARTIAL_TERMINAL.getKey().equals(signTask.getPermissionType())) {
      //部分
      signTask.setSignTaskCusRelationships(null);
      signTask.setSignTaskTerminalRelationships(null);
      Validate.isTrue(
          (!CollectionUtils.isEmpty(signTask.getSignTaskOrgRelationships()) || !CollectionUtils
              .isEmpty(signTask.getSignTaskChannelRelationships()) || !CollectionUtils
              .isEmpty(signTask.getSignTaskTagRelationships())), "部分终端/客户必须传值");

    }
    // 验证长度，被验证的这些字段符合特征: 字段类型为String，且不为PK （注意连续空字符串的情况）
    Validate.isTrue(signTask.getSignTaskName() == null || signTask.getSignTaskName().length() < 64,
        "活动签约配置编码,在进行添加时填入值超过了限定长度(64)，请检查!");
    //验证时间
    Validate.isTrue(signTask.getSignTaskEndTime().after(signTask.getSignTaskStartTime()),
        "活动签约配置生效结束时间必须大于生效开始时间！");
  }
}
