/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeExceptionRecord;
import com.biz.crm.cps.external.barcode.local.mapper.ScanCodeExceptionRecordMapper;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeExceptionRecordRepository;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeExceptionRecordService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeExceptionRecordDto;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeExceptionRecordVo;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ScanCodeExceptionRecordServiceImpl
implements ScanCodeExceptionRecordService {
    @Autowired
    private ScanCodeExceptionRecordRepository scanCodeExceptionRecordRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    @Transactional
    public void save(ScanCodeExceptionRecordDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getBarCode())) {
            return;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"bar_code", (Object)dto.getBarCode());
        queryWrapper.eq((Object)"sup_cust_code", (Object)dto.getSupCustCode());
        queryWrapper.eq((Object)"terminal_code", (Object)dto.getTerminalCode());
        Integer count = ((ScanCodeExceptionRecordMapper)this.scanCodeExceptionRecordRepository.getBaseMapper()).selectCount((Wrapper)queryWrapper);
        if (count > 0) {
            return;
        }
        ScanCodeExceptionRecord entity = new ScanCodeExceptionRecord();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)entity));
        Date date = new Date();
        entity.setCreateTime(date);
        entity.setCreateAccount(this.loginUserService.getLoginAccountName());
        entity.setModifyTime(date);
        entity.setModifyAccount(this.loginUserService.getLoginAccountName());
        this.scanCodeExceptionRecordRepository.save((Object)entity);
    }

    @Override
    public Page<ScanCodeExceptionRecordVo> findByConditions(Pageable pageable, ScanCodeExceptionRecordDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        return this.scanCodeExceptionRecordRepository.findByConditions(pageable, dto);
    }
}

