/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.barcode.local.config.BarCodeConfig;
import com.biz.crm.cps.external.barcode.local.entity.BarCodeLatestCirculation;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.repository.BarCodeLatestCirculationRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordVoRepository;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordBatchService;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.BarCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ConsumerScanCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ConsumerScanCodeRecordEventListener;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import com.biz.crm.cps.external.barcode.sdk.service.BarCodeVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import com.biz.crm.cps.external.feign.meiyun.MyScanFeignClient;
import com.biz.crm.cps.external.feign.vo.MyBarCodeInfoVo;
import com.biz.crm.cps.external.feign.vo.XmlRequestVo;
import com.biz.crm.cps.external.feign.vo.XmlResponseScanVo;
import com.biz.crm.mdm.material.MdmMaterialFeign;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class ScanCodeRecordBatchServiceImpl
implements ScanCodeRecordBatchService {
    private static final Logger log = LoggerFactory.getLogger(ScanCodeRecordBatchServiceImpl.class);
    @Autowired
    private ScanCodeRecordRepository scanCodeRecordRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private BarCodeLatestCirculationRepository barCodeLatestCirculationRepository;
    @Autowired(required=false)
    private List<ScanCodeRecordEventListener> scanCodeRecordEventListeners;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private ScanCodeRecordVoRepository scanCodeRecordVoRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private List<ConsumerScanCodeRecordEventListener> consumerScanCodeRecordEventListeners;
    @Autowired
    private BarCodeConfig barCodeConfig;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private MyScanFeignClient myScanFeignClient;
    @Autowired
    private ScanCodeRecordService scanCodeRecordService;
    @Autowired
    private MdmMaterialFeign mdmMaterialFeign;
    @Autowired
    private BarCodeVoService barCodeVoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void createBatch(ScanCodeRecordDto scanCodeRecordDto) {
        List<ScanCodeRecordDto> list = this.createForm(scanCodeRecordDto);
        ArrayList<String> barCodeList = new ArrayList<String>();
        RLock[] lockArray = new RLock[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lockArray[i] = this.redissonClient.getLock(String.format("lock:barCode:%s", list.get(i).getBarCode()));
            barCodeList.add(list.get(i).getBarCode());
        }
        RLock multiLock = this.redissonClient.getMultiLock(lockArray);
        try {
            multiLock.lock(10L, TimeUnit.SECONDS);
            log.info("\u626b\u7801\u4fe1\u606f\u4fdd\u5b58\u83b7\u53d6\u8054\u9501\u6210\u529f\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JSON.toJSONString((Object)scanCodeRecordDto));
            List<String> recordBarCode = this.scanCodeRecordService.findRecordBarCode(barCodeList);
            if (!CollectionUtils.isEmpty(recordBarCode)) {
                Validate.isTrue((boolean)false, (String)String.format("\u76d2\u7801\uff1a%s\u5df2\u626b\u7801\u5165\u5e93", String.join((CharSequence)",", recordBarCode)), (Object[])new Object[0]);
            }
            HashMap<ScanCodeRecordDto, ScanCodeRecord> entityVoMap = new HashMap<ScanCodeRecordDto, ScanCodeRecord>();
            ArrayList barCodeDtos = new ArrayList();
            list.forEach(item -> {
                ScanCodeRecord scanCodeRecord = (ScanCodeRecord)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(item, ScanCodeRecord.class, HashSet.class, ArrayList.class, new String[0])));
                scanCodeRecord.setCreateTime(new Date());
                scanCodeRecord.setBarCodeParticipatorCode(item.getScanParticipatorCode());
                scanCodeRecord.setCreateAccount(item.getTerminalName());
                scanCodeRecord.setTenantCode(TenantUtils.getTenantCode());
                if (Objects.nonNull(this.generateCodeService)) {
                    scanCodeRecord.setRecordCode((String)this.generateCodeService.generateCode("scanRecord", 1).get(0));
                } else {
                    scanCodeRecord.setRecordCode(String.valueOf(System.currentTimeMillis()));
                }
                entityVoMap.put((ScanCodeRecordDto)item, scanCodeRecord);
                BarCodeDto barCodeDto = new BarCodeDto();
                BeanUtils.copyProperties((Object)item, (Object)barCodeDto);
                barCodeDto.setFlatAncestors(barCodeDto.getParentBarCode() + "," + barCodeDto.getBarCode());
                barCodeDto.setProductCode(item.getMaterialCode());
                BigDecimal standardUnit = new BigDecimal(1.0 / (double)item.getSpecification().intValue());
                barCodeDto.setStandardUnitBottleValue(standardUnit);
                barCodeDto.setStandardUnitBoxValue(standardUnit);
                barCodeDtos.add(barCodeDto);
            });
            this.scanCodeRecordRepository.saveBatch(entityVoMap.values());
            this.barCodeVoService.createBatch(barCodeDtos);
            entityVoMap.forEach((k, v) -> {
                ScanCodeRecordEventDto scanCodeRecordEventDto = (ScanCodeRecordEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)v, ScanCodeRecordEventDto.class, HashSet.class, ArrayList.class, new String[0]);
                this.notifyEvents(scanCodeRecordEventDto, (ScanCodeRecordDto)k);
            });
        }
        finally {
            multiLock.unlock();
        }
    }

    private List<ScanCodeRecordDto> createForm(ScanCodeRecordDto scanCodeRecordDto) {
        scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
        ArrayList<ScanCodeRecordDto> list = new ArrayList<ScanCodeRecordDto>();
        HashSet packetCodeSet = new HashSet();
        HashSet materialCodeSet = new HashSet();
        scanCodeRecordDto.getBarCodeList().forEach(barCode -> {
            String[] packetCodes;
            MyBarCodeInfoVo myBarCodeInfoVo;
            XmlRequestVo xmlRequestVo = new XmlRequestVo("YPYM_COD_REL_KEY", String.format("{\"codeStr\":\"%s\",\"codeFlowFlag\":\"false\"}", barCode));
            long myStartTime = System.currentTimeMillis();
            XmlResponseScanVo xmlResponseVo = this.myScanFeignClient.scanBarCodeInfo(xmlRequestVo);
            log.info("\u8c03\u7528\u7f8e\u4e91\u6761\u7801\u6eaf\u6e90\u63a5\u53e3\u7528\u65f6:{}ms, \u8fd4\u56de\u53c2\u6570:{}", (Object)(System.currentTimeMillis() - myStartTime), (Object)JSON.toJSONString((Object)xmlResponseVo));
            if (xmlResponseVo == null || StringUtils.isBlank((CharSequence)xmlResponseVo.dataValue())) {
                Validate.isTrue((boolean)false, (String)"\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (Object[])new Object[0]);
            }
            if ((myBarCodeInfoVo = (MyBarCodeInfoVo)JSON.parseObject((String)xmlResponseVo.dataValue(), MyBarCodeInfoVo.class)) == null || StringUtils.isBlank((CharSequence)myBarCodeInfoVo.getOutBottleCode()) || StringUtils.isBlank((CharSequence)myBarCodeInfoVo.getBoxCode()) || StringUtils.isBlank((CharSequence)myBarCodeInfoVo.getItemCode()) || StringUtils.isBlank((CharSequence)myBarCodeInfoVo.getItemName()) || StringUtils.isBlank((CharSequence)myBarCodeInfoVo.getCustType()) || StringUtils.isBlank((CharSequence)myBarCodeInfoVo.getSupCustCode()) || StringUtils.isBlank((CharSequence)myBarCodeInfoVo.getSupCustName())) {
                Validate.isTrue((boolean)false, (String)"\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (Object[])new Object[0]);
            }
            for (String packetCode : packetCodes = myBarCodeInfoVo.getPacketCode().split(",")) {
                if (packetCodeSet.contains(packetCode)) {
                    Validate.isTrue((boolean)false, (String)String.format("\u76d2\u7801\uff1a%s\u91cd\u590d", packetCode), (Object[])new Object[0]);
                }
                packetCodeSet.add(packetCode);
                ScanCodeRecordDto dto = new ScanCodeRecordDto();
                BeanUtils.copyProperties((Object)scanCodeRecordDto, (Object)dto);
                dto.setBarCode(packetCode);
                dto.setProductCode(myBarCodeInfoVo.getItemCode());
                dto.setBarCodeType("2");
                dto.setScanType("1");
                dto.setEnterType("2");
                dto.setParentBarCode(myBarCodeInfoVo.getBoxCode());
                dto.setMaterialCode(myBarCodeInfoVo.getItemCode());
                dto.setMaterialName(myBarCodeInfoVo.getItemName());
                materialCodeSet.add(myBarCodeInfoVo.getItemCode());
                list.add(dto);
            }
        });
        List materialList = this.mdmMaterialFeign.findMaterialList(new ArrayList(materialCodeSet));
        HashMap specificationMap = new HashMap(materialList.size());
        if (!CollectionUtils.isEmpty((Collection)materialList)) {
            materialList.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getSpecification())) {
                    String spec = item.getSpecification().substring(item.getSpecification().lastIndexOf("*") + 1);
                    specificationMap.put(item.getMaterialCode(), Integer.parseInt(spec));
                } else {
                    specificationMap.put(item.getMaterialCode(), 1);
                }
            });
        }
        list.forEach(item -> item.setSpecification((Integer)specificationMap.get(item.getMaterialCode())));
        return list;
    }

    private ConsumerScanCodeDto createConsumerScanCodeDtoForm(String parentBarCode, ConsumerScanCodeDto consumerScanCodeDto) {
        BarCodeLatestCirculation barCodeLatestCirculation = this.barCodeLatestCirculationRepository.findByBarCode(parentBarCode);
        Validate.notNull((Object)((Object)barCodeLatestCirculation), (String)"\u626b\u76d6\u5185\u7801\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u76d2\u7801\u7684\u6700\u65b0\u6d41\u8f6c\u4eba\uff01", (Object[])new Object[0]);
        consumerScanCodeDto.setParticipatorType(barCodeLatestCirculation.getParticipatorType());
        consumerScanCodeDto.setBarCodeParticipatorCode(barCodeLatestCirculation.getBarCodeParticipatorCode());
        return consumerScanCodeDto;
    }

    private void notifyEvents(ScanCodeRecordEventDto scanCodeRecordEventDto, ScanCodeRecordDto scanCodeRecordDto) {
        if (Objects.isNull(scanCodeRecordEventDto) || Objects.isNull(scanCodeRecordDto)) {
            return;
        }
        scanCodeRecordEventDto.setProductCode(scanCodeRecordDto.getProductCode());
        if ("consumer".equals(scanCodeRecordEventDto.getParticipatorType()) && !CollectionUtils.isEmpty(this.consumerScanCodeRecordEventListeners)) {
            if (scanCodeRecordDto.getBarCodeParticipatorCode() == null) {
                ConsumerScanCodeDto consumerScanCodeDtoForm = this.createConsumerScanCodeDtoForm(scanCodeRecordDto.getParentBarCode(), scanCodeRecordDto.getConsumerScanCodeDto());
                scanCodeRecordEventDto.setConsumerScanCodeDto(consumerScanCodeDtoForm);
            } else {
                scanCodeRecordEventDto.setConsumerScanCodeDto(scanCodeRecordDto.getConsumerScanCodeDto());
            }
            for (ConsumerScanCodeRecordEventListener consumerScanCodeRecordEventListener : this.consumerScanCodeRecordEventListeners) {
                if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException())) {
                    consumerScanCodeRecordEventListener.onSuccessScan(scanCodeRecordEventDto);
                    continue;
                }
                consumerScanCodeRecordEventListener.onFailScan(scanCodeRecordEventDto);
            }
        }
        if (!CollectionUtils.isEmpty(this.scanCodeRecordEventListeners)) {
            for (ScanCodeRecordEventListener scanCodeRecordEventListener : this.scanCodeRecordEventListeners) {
                if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException())) {
                    scanCodeRecordEventListener.onSuccessScan(scanCodeRecordEventDto);
                    continue;
                }
                scanCodeRecordEventListener.onFailScan(scanCodeRecordEventDto);
            }
        }
        if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException())) {
            this.scanSuccessCallback(scanCodeRecordDto.getBarCode());
        }
    }

    private void scanSuccessCallback(String barCode) {
        String scanSuccessCallbackUrl = this.barCodeConfig.getScanSuccessCallbackUrlList();
        if (StringUtils.isBlank((CharSequence)scanSuccessCallbackUrl)) {
            return;
        }
        List<ScanCodeRecordVo> byScanParticipatorCodeAndBarCode = this.scanCodeRecordVoRepository.findByScanParticipatorCodeAndBarCode(this.loginUserService.getLoginUser().getConsumerCode(), barCode);
        if (CollectionUtils.isEmpty(byScanParticipatorCodeAndBarCode)) {
            return;
        }
        ScanCodeRecordVo scanCodeRecordVo = byScanParticipatorCodeAndBarCode.get(0);
        if (Objects.isNull(scanCodeRecordVo)) {
            return;
        }
        try {
            String[] split = scanSuccessCallbackUrl.split(";");
            for (int i = 0; i < split.length; ++i) {
                this.restTemplate.postForObject(split[i], (Object)scanCodeRecordVo, null, new Object[0]);
            }
        }
        catch (RuntimeException e) {
            log.warn("\u56de\u8c03\u5916\u90e8\u7cfb\u7edf\u9519\u8bef\uff01");
        }
    }
}

