/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.mapper.ScanCodeRecordMapper;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordRepository;
import com.biz.crm.cps.external.barcode.local.service.ScanCodeRecordService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeRecordServiceImpl
implements ScanCodeRecordService {
    @Autowired
    private ScanCodeRecordRepository scanCodeRecordRepository;

    @Override
    public ScanCodeRecord findByBarCodeAndParticipatorType(String barCode, String participatorType, String scanCodeException) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{barCode, participatorType, scanCodeException})) {
            return null;
        }
        return this.scanCodeRecordRepository.findByBarCodeAndParticipatorType(barCode, participatorType, scanCodeException);
    }

    @Override
    public List<String> findRecordBarCode(List<String> barCodeList) {
        if (CollectionUtils.isEmpty(barCodeList)) {
            return new ArrayList<String>();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"bar_code"});
        queryWrapper.in((Object)"bar_code", barCodeList);
        List scanCodeRecords = ((ScanCodeRecordMapper)this.scanCodeRecordRepository.getBaseMapper()).selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)scanCodeRecords)) {
            return new ArrayList<String>();
        }
        return scanCodeRecords.stream().map(ScanCodeRecord::getBarCode).collect(Collectors.toList());
    }
}

