/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.participator.local.entity.DealerEntity;
import com.biz.crm.cps.business.participator.local.repository.DealerRepository;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.external.barcode.local.config.BarCodeConfig;
import com.biz.crm.cps.external.barcode.local.entity.BarCode;
import com.biz.crm.cps.external.barcode.local.entity.BarCodeLatestCirculation;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeChannel;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecord;
import com.biz.crm.cps.external.barcode.local.entity.ScanCodeRecordFactory;
import com.biz.crm.cps.external.barcode.local.repository.BarCodeLatestCirculationRepository;
import com.biz.crm.cps.external.barcode.local.repository.BarCodeRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeChannelRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordFactoryRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordRepository;
import com.biz.crm.cps.external.barcode.local.repository.ScanCodeRecordVoRepository;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeJudgeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.BarCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ConsumerScanCodeDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.event.ConsumerScanCodeRecordEventListener;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import com.biz.crm.cps.external.barcode.sdk.service.BarCodeVoService;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.ScanCodeRecordVo;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class ScanCodeRecordVoServiceImpl
implements ScanCodeRecordVoService {
    private static final Logger log = LoggerFactory.getLogger(ScanCodeRecordVoServiceImpl.class);
    @Autowired
    private ScanCodeRecordRepository scanCodeRecordRepository;
    @Autowired
    private ScanCodeRecordFactoryRepository scanCodeRecordFactoryRepository;
    @Autowired
    private ScanCodeChannelRepository scanCodeChannelRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private BarCodeLatestCirculationRepository barCodeLatestCirculationRepository;
    @Autowired(required=false)
    private List<ScanCodeRecordEventListener> scanCodeRecordEventListeners;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private BarCodeRepository barCodeRepository;
    @Autowired
    private DealerRepository dealerRepository;
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private ScanCodeRecordVoRepository scanCodeRecordVoRepository;
    @Autowired
    private BarCodeVoService barCodeVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TerminalMdmService terminalMdmService;
    @Autowired(required=false)
    private List<ConsumerScanCodeRecordEventListener> consumerScanCodeRecordEventListeners;
    @Autowired
    private BarCodeConfig barCodeConfig;
    @Autowired
    private RestTemplate restTemplate;

    public Integer countByScanCodeRecordDto(ScanCodeRecordStatisticsDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        return this.scanCodeRecordVoRepository.countByScanCodeRecordDto(dto);
    }

    public Page<ScanCodeRecordVo> findByConditions(ScanCodeRecordPageDto dto, Pageable pageable) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new ScanCodeRecordPageDto();
        }
        return this.scanCodeRecordVoRepository.findByConditions(dto, pageable);
    }

    public BigDecimal countSalesByScanCodeRecordPageDto(ScanCodeRecordPageDto dto) {
        BigDecimal countSales = BigDecimal.ZERO;
        String saleStandardUnit = this.barCodeConfig.getSaleStandardUnit();
        if (dto == null || StringUtils.isBlank((CharSequence)saleStandardUnit)) {
            return countSales;
        }
        List<ScanCodeRecordVo> list = this.scanCodeRecordVoRepository.findByConditions(dto);
        if (CollectionUtils.isEmpty(list)) {
            return countSales;
        }
        if (saleStandardUnit.equals(BarCodeTypeEnum.BOX.getKey())) {
            list.stream().forEach(scanCodeRecordVo -> countSales.add(scanCodeRecordVo.getStandardUnitBoxValue()));
        } else if (saleStandardUnit.equals(BarCodeTypeEnum.BOTTLE.getKey())) {
            list.stream().forEach(scanCodeRecordVo -> countSales.add(scanCodeRecordVo.getStandardUnitBottleValue()));
        }
        return countSales;
    }

    public ScanCodeRecordVo saveMcScanCodeRecord(ScanCodeRecordDto scanCodeRecordDto) {
        Validate.notNull((Object)scanCodeRecordDto, (String)"\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)scanCodeRecordDto.getConsumerScanCodeDto(), (String)"\u4f20\u5165\u7684\u6d88\u8d39\u8005\u626b\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.save(scanCodeRecordDto);
    }

    public ScanCodeRecordVo dealerScanCode(ScanCodeRecordDto scanCodeRecordDto) {
        return null;
    }

    @Transactional
    public ScanCodeRecordVo create(ScanCodeRecordDto scanCodeRecordDto) {
        this.createForm(scanCodeRecordDto);
        scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.PROFIT_OUT.getCode());
        scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
        if (ParticipatorTypeEnum.DEALER.getKey().equals(scanCodeRecordDto.getParticipatorType()) && ScanTypeEnum.OUT_WAREHOUSE.getCode().equals(scanCodeRecordDto.getScanType())) {
            this.dealerScanCodeValidate(scanCodeRecordDto);
        } else if (ParticipatorTypeEnum.TERMINAL.getKey().equals(scanCodeRecordDto.getParticipatorType())) {
            this.terminalScanCodeValidate(scanCodeRecordDto);
        }
        return this.save(scanCodeRecordDto);
    }

    private void terminalScanCodeValidate(ScanCodeRecordDto scanCodeRecordDto) {
        ScanCodeRecord dealerScanCode;
        int scanCount;
        BarCode barCode = this.barCodeRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        ScanCodeRecord record = this.scanCodeRecordRepository.findByScanCodeRecordDto(scanCodeRecordDto);
        if (barCode == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u8be5\u7801");
        }
        int count = this.scanCodeRecordRepository.findRangeCountByProductCode(scanCodeRecordDto.getProductCode());
        if (count == 0) {
            throw new IllegalArgumentException("\u8be5\u5546\u54c1\u4e0d\u662f\u5206\u5229\u5546\u54c1");
        }
        if (count > 0 && !BarCodeTypeEnum.BOX.getFlag().equals(scanCodeRecordDto.getBarCodeType())) {
            throw new IllegalArgumentException("\u8bf7\u626b\u63cf\u5916\u7bb1\u4e0a\u7684\u7bb1\u7801");
        }
        if (record != null) {
            throw new IllegalArgumentException("\u8be5\u7bb1\u8d27\u7269\u5df2\u5165\u5e93");
        }
        List<AgreementVo> agreementVos = this.findAgreementVos(scanCodeRecordDto);
        ScanCodeRecord dealerRecord = this.scanCodeRecordRepository.findDealerRecord(scanCodeRecordDto);
        List result = this.terminalMdmService.findTerminalSupplyByCode(scanCodeRecordDto.getScanParticipatorCode());
        BarCodeLatestCirculation barCodeLatestCirculation = this.barCodeLatestCirculationRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        if (record == null && dealerRecord != null && !CollectionUtils.isEmpty(agreementVos)) {
            result.forEach(item -> {
                List supplys = item.getSupplys();
                if (!CollectionUtils.isEmpty((Collection)supplys)) {
                    supplys.forEach(supply -> {
                        if (dealerRecord.getBarCodeParticipatorCode().equals(supply.getCustomerCode())) {
                            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
                            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.NORMAL_IN.getCode());
                            return;
                        }
                        if (barCodeLatestCirculation.getBarCodeParticipatorCode().equals(supply.getCustomerCode())) {
                            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_TERMINAL_DEALER.getCode());
                            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
                            return;
                        }
                    });
                }
            });
        }
        if (record == null && !CollectionUtils.isEmpty(agreementVos) && (scanCount = this.barCodeRepository.findCountByBarCode(scanCodeRecordDto.getBarCode(), BarCodeTypeEnum.COVER_CODE.getFlag(), ScanCodeExceptionEnum.NO.getCode())) > 0) {
            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_OTHER_CONSUMER.getCode());
            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
            return;
        }
        if (record == null && !CollectionUtils.isEmpty(agreementVos) && (dealerScanCode = this.scanCodeRecordRepository.findAllDealerRecordByBarCode(scanCodeRecordDto)) != null && !ScanCodeExceptionEnum.NO.getCode().equals(dealerScanCode.getScanCodeException())) {
            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.ERROE_OUT_FOR_DEALER.getCode());
            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
            return;
        }
        ScanCodeRecord scanCodeRecord = this.scanCodeRecordRepository.findByBarCodeAndScanType(scanCodeRecordDto.getBarCode(), null, null);
        if (scanCodeRecord != null && !scanCodeRecord.getBarCodeParticipatorCode().equals(scanCodeRecordDto.getScanParticipatorCode())) {
            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_OTHER_TERMINAL.getCode());
            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_IN.getCode());
            return;
        }
    }

    private void dealerScanCodeValidate(ScanCodeRecordDto scanCodeRecordDto) {
        BarCode barCode = this.barCodeRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        DealerEntity dealerEntity = this.dealerRepository.findByCustomerCodeAndEnable(scanCodeRecordDto.getScanParticipatorCode(), EnableStatusEnum.ENABLE.getCode());
        List<AgreementVo> agreementVos = this.findAgreementVos(scanCodeRecordDto);
        Set templateCodes = agreementVos.stream().map(AgreementVo::getTemplateCode).collect(Collectors.toSet());
        scanCodeRecordDto.setTemplateCodes(templateCodes);
        if (barCode == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u8bc6\u522b\u8be5\u7801");
        }
        ScanCodeRecord record = this.scanCodeRecordRepository.findByBarCodeAndScanType(scanCodeRecordDto.getBarCode(), ScanTypeEnum.OUT_WAREHOUSE.getCode(), ParticipatorTypeEnum.DEALER.getKey());
        List<ScanCodeRecordFactory> factoryRecords = this.scanCodeRecordFactoryRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        ScanCodeRecordFactory factoryRecord = null;
        if (!CollectionUtils.isEmpty(factoryRecords)) {
            factoryRecord = factoryRecords.get(0);
        }
        if (record != null && scanCodeRecordDto.getScanParticipatorCode().equals(record.getScanParticipatorCode())) {
            throw new IllegalArgumentException("\u8be5\u7bb1\u8d27\u7269\u5df2\u51fa\u5e93");
        }
        if (factoryRecord != null && dealerEntity == null && record == null && scanCodeRecordDto.getScanParticipatorCode().equals(factoryRecord.getDealerCode())) {
            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.NORMAL_OUT.getCode());
            return;
        }
        if (CollectionUtils.isEmpty(agreementVos) && scanCodeRecordDto.getScanParticipatorCode().equals(factoryRecord.getDealerCode())) {
            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.NORMAL_IN.getCode());
            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
            return;
        }
        if (record == null && factoryRecord != null && !scanCodeRecordDto.getScanParticipatorCode().equals(factoryRecord.getDealerCode())) {
            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_DEALER_FACTORY.getCode());
            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_OUT.getCode());
            return;
        }
        if (record != null && !scanCodeRecordDto.getScanParticipatorCode().equals(record.getScanParticipatorCode())) {
            scanCodeRecordDto.setScanCodeException(ScanCodeExceptionEnum.CROSS_OTHERS.getCode());
            scanCodeRecordDto.setScanCodeJudge(ScanCodeJudgeEnum.EXCEPTION_OUT.getCode());
            return;
        }
    }

    private List<AgreementVo> findAgreementVos(ScanCodeRecordDto scanCodeRecordDto) {
        Validate.notNull((Object)scanCodeRecordDto, (String)"\u626b\u7801\u8bb0\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        if (BarCodeTypeEnum.COVER_CODE.getFlag().equals(scanCodeRecordDto.getBarCodeType())) {
            ConsumerScanCodeDto consumerScanCodeDto = scanCodeRecordDto.getConsumerScanCodeDto();
            this.buildLoginUserAgreementDto(consumerScanCodeDto.getBarCodeParticipatorCode(), consumerScanCodeDto.getParticipatorType(), loginUserAgreementDto);
        } else {
            this.buildLoginUserAgreementDto(scanCodeRecordDto.getBarCodeParticipatorCode(), scanCodeRecordDto.getParticipatorType(), loginUserAgreementDto);
        }
        List agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto);
        return agreementVos;
    }

    private void buildLoginUserAgreementDto(String barCodeParticipatorCode, String participatorType, LoginUserAgreementDto loginUserAgreementDto) {
        if (ParticipatorTypeEnum.TERMINAL.getKey().equals(participatorType)) {
            loginUserAgreementDto.setTerminalCode(barCodeParticipatorCode);
        } else if (ParticipatorTypeEnum.DEALER.getKey().equals(participatorType)) {
            loginUserAgreementDto.setCustomerCode(barCodeParticipatorCode);
        }
        loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        loginUserAgreementDto.setSignStatus(SignStatusEnum.SIGNED.getCode());
    }

    @Transactional
    public ScanCodeRecordVo save(ScanCodeRecordDto scanCodeRecordDto) {
        ScanCodeRecord scanCodeRecord = (ScanCodeRecord)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecordDto, ScanCodeRecord.class, HashSet.class, ArrayList.class, new String[0]));
        scanCodeRecord.setCreateTime(new Date());
        if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecord.getScanCodeException())) {
            scanCodeRecord.setBarCodeParticipatorCode(scanCodeRecordDto.getScanParticipatorCode());
        }
        scanCodeRecord.setCreateAccount(this.loginUserService.getLoginAccountName());
        scanCodeRecord.setTenantCode(TenantUtils.getTenantCode());
        scanCodeRecord.setRecordCode(String.valueOf(System.currentTimeMillis()));
        this.scanCodeRecordRepository.save((Object)scanCodeRecord);
        if (ParticipatorTypeEnum.DEALER.getKey().equals(scanCodeRecord.getParticipatorType()) && ScanTypeEnum.OUT_WAREHOUSE.getCode().equals(scanCodeRecord.getScanType()) && scanCodeRecordDto.getScanCodeChannelVo() != null) {
            ScanCodeChannel scanCodeChannel = (ScanCodeChannel)this.nebulaToolkitService.copyObjectByBlankList((Object)scanCodeRecordDto.getScanCodeChannelVo(), ScanCodeChannel.class, HashSet.class, null, new String[0]);
            this.scanCodeChannelRepository.save(scanCodeChannel);
        }
        if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecord.getScanCodeException()) && (ScanCodeJudgeEnum.PROFIT_OUT.getCode().equals(scanCodeRecord.getScanCodeJudge()) || ScanCodeJudgeEnum.PROFIT_IN.getCode().equals(scanCodeRecord.getScanCodeJudge()))) {
            List<BarCodeLatestCirculation> list = this.createBarCodeLatestCirculationFrom(scanCodeRecord, scanCodeRecordDto);
            this.barCodeLatestCirculationRepository.saveOrUpdateBatch(list);
        }
        ScanCodeRecordEventDto scanCodeRecordEventDto = (ScanCodeRecordEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecordDto, ScanCodeRecordEventDto.class, HashSet.class, ArrayList.class, new String[]{"templateCodes"});
        this.notifyEvents(scanCodeRecordEventDto, scanCodeRecordDto);
        return (ScanCodeRecordVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecord, ScanCodeRecordVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private List<BarCodeLatestCirculation> createBarCodeLatestCirculationFrom(ScanCodeRecord scanCodeRecord, ScanCodeRecordDto scanCodeRecordDto) {
        ArrayList<BarCodeLatestCirculation> list = new ArrayList<BarCodeLatestCirculation>();
        List<Object> barCodes = new ArrayList();
        if (BarCodeTypeEnum.BOX.getFlag().equals(scanCodeRecord.getBarCodeType())) {
            barCodes = this.barCodeRepository.findByParentBarCode(scanCodeRecord.getBarCode());
        }
        if (BarCodeTypeEnum.BOTTLE.getFlag().equals(scanCodeRecord.getBarCodeType())) {
            BarCode barCode2 = this.barCodeRepository.findByBarCode(scanCodeRecordDto.getParentBarCode());
            barCodes.add((Object)barCode2);
        }
        if (!CollectionUtils.isEmpty(barCodes)) {
            List<String> codes = barCodes.stream().map(BarCode::getBarCode).collect(Collectors.toList());
            List<BarCodeLatestCirculation> barCodeLatestCirculations = this.barCodeLatestCirculationRepository.findByBarCodes(codes);
            Map<String, String> map = barCodeLatestCirculations.stream().collect(Collectors.toMap(BarCodeLatestCirculation::getBarCode, BaseIdEntity::getId));
            barCodes.stream().forEach(barCode -> {
                BarCodeLatestCirculation barCodeLatest = (BarCodeLatestCirculation)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecord, BarCodeLatestCirculation.class, HashSet.class, ArrayList.class, new String[0])));
                barCodeLatest.setId(null);
                String id = (String)map.get(barCode.getBarCode());
                if (StringUtils.isNotBlank((CharSequence)id)) {
                    barCodeLatest.setId(id);
                }
                if (BarCodeTypeEnum.BOX.getFlag().equals(barCode.getBarCodeType())) {
                    barCodeLatest.setScanCodeException(ScanCodeExceptionEnum.BOTTLE.getCode());
                }
                if (BarCodeTypeEnum.BOTTLE.getFlag().equals(barCode.getBarCodeType())) {
                    barCodeLatest.setScanCodeException(ScanCodeExceptionEnum.BOX.getCode());
                }
                barCodeLatest.setBarCode(barCode.getBarCode());
                barCodeLatest.setBarCodeType(barCode.getBarCodeType());
                list.add(barCodeLatest);
            });
        }
        BarCodeLatestCirculation barCodeLatestCirculation = (BarCodeLatestCirculation)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)scanCodeRecord, BarCodeLatestCirculation.class, HashSet.class, ArrayList.class, new String[0]));
        BarCodeLatestCirculation latestCirculation = this.barCodeLatestCirculationRepository.findByBarCode(scanCodeRecord.getBarCode());
        barCodeLatestCirculation.setId(null);
        if (latestCirculation != null) {
            barCodeLatestCirculation.setId(latestCirculation.getId());
        }
        list.add(barCodeLatestCirculation);
        return list;
    }

    private void createForm(ScanCodeRecordDto scanCodeRecordDto) {
        this.participatorValidate(scanCodeRecordDto);
        BarCode current = this.barCodeRepository.findByBarCode(scanCodeRecordDto.getBarCode());
        Validate.notNull((Object)((Object)current), (String)"\u5546\u54c1\u4e32\u7801\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        if ("consumer".equals(scanCodeRecordDto.getParticipatorType())) {
            Validate.isTrue((boolean)BarCodeTypeEnum.COVER_CODE.getFlag().equals(current.getBarCodeType()), (String)"\u6d88\u8d39\u8005\u626b\u7801\u65f6\uff0c\u53ea\u80fd\u626b\u76d6\u5185\u7801\uff01", (Object[])new Object[0]);
        } else {
            Validate.isTrue((!BarCodeTypeEnum.COVER_CODE.getFlag().equals(current.getBarCodeType()) ? 1 : 0) != 0, (String)"\u626b\u63cf\u7684\u975e\u7bb1\u7801\uff01", (Object[])new Object[0]);
            Validate.isTrue((!BarCodeTypeEnum.BOTTLE.getFlag().equals(current.getBarCodeType()) ? 1 : 0) != 0, (String)"\u626b\u63cf\u7684\u975e\u7bb1\u7801\uff01", (Object[])new Object[0]);
        }
        scanCodeRecordDto.setBarCodeType(current.getBarCodeType());
        scanCodeRecordDto.setProductCode(current.getProductCode());
        scanCodeRecordDto.setParentBarCode(current.getParentBarCode());
    }

    private BarCodeDto findByExternalUrl(String barCode) {
        String externalUrl = this.barCodeConfig.getExternalUrl();
        if (StringUtils.isBlank((CharSequence)externalUrl)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("barCode", barCode);
        BarCodeDto barCodeDto = (BarCodeDto)this.restTemplate.postForObject(externalUrl, map, BarCodeDto.class, new Object[0]);
        if (barCode == null) {
            return null;
        }
        return barCodeDto;
    }

    private void participatorValidate(ScanCodeRecordDto dto) {
        this.createValidation(dto);
        LoginUserDetails loginUser = this.loginUserService.getLoginUser();
        String scanParticipatorCode = null;
        String participatorType = null;
        if (Objects.nonNull(loginUser)) {
            scanParticipatorCode = loginUser.getConsumerCode();
            participatorType = loginUser.getUsertype();
        } else {
            this.createConsumerValidation(dto);
            scanParticipatorCode = dto.getConsumerScanCodeDto().getExternalId();
            participatorType = "consumer";
        }
        Validate.notNull((Object)scanParticipatorCode, (String)"\u5f53\u524d\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)participatorType, (String)"\u5f53\u524d\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setScanParticipatorCode(scanParticipatorCode);
        dto.setParticipatorType(participatorType);
    }

    private void createConsumerValidation(ScanCodeRecordDto dto) {
        ConsumerScanCodeDto consumerScanCodeDto = dto.getConsumerScanCodeDto();
        Validate.notNull((Object)consumerScanCodeDto, (String)"\u6d88\u8d39\u8005\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)consumerScanCodeDto.getExternalId(), (String)"\u6d88\u8d39\u8005\u5916\u90e8id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)consumerScanCodeDto.getPhone(), (String)"\u6d88\u8d39\u8005\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)consumerScanCodeDto.getNickname(), (String)"\u6d88\u8d39\u8005\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createValidation(ScanCodeRecordDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getBarCode(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEnterType(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5f55\u5165\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getScanType(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u626b\u7801\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private ConsumerScanCodeDto createConsumerScanCodeDtoForm(String parentBarCode, ConsumerScanCodeDto consumerScanCodeDto) {
        BarCodeLatestCirculation barCodeLatestCirculation = this.barCodeLatestCirculationRepository.findByBarCode(parentBarCode);
        Validate.notNull((Object)((Object)barCodeLatestCirculation), (String)"\u626b\u76d6\u5185\u7801\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u76d2\u7801\u7684\u6700\u65b0\u6d41\u8f6c\u4eba\uff01", (Object[])new Object[0]);
        consumerScanCodeDto.setParticipatorType(barCodeLatestCirculation.getParticipatorType());
        consumerScanCodeDto.setBarCodeParticipatorCode(barCodeLatestCirculation.getBarCodeParticipatorCode());
        return consumerScanCodeDto;
    }

    private void notifyEvents(ScanCodeRecordEventDto scanCodeRecordEventDto, ScanCodeRecordDto scanCodeRecordDto) {
        if (Objects.isNull(scanCodeRecordEventDto) || Objects.isNull(scanCodeRecordDto)) {
            return;
        }
        scanCodeRecordEventDto.setTemplateCodes(scanCodeRecordDto.getTemplateCodes());
        scanCodeRecordEventDto.setProductCode(scanCodeRecordDto.getProductCode());
        if ("consumer".equals(scanCodeRecordEventDto.getParticipatorType()) && !CollectionUtils.isEmpty(this.consumerScanCodeRecordEventListeners)) {
            if (scanCodeRecordDto.getBarCodeParticipatorCode() == null) {
                ConsumerScanCodeDto consumerScanCodeDtoForm = this.createConsumerScanCodeDtoForm(scanCodeRecordDto.getParentBarCode(), scanCodeRecordDto.getConsumerScanCodeDto());
                scanCodeRecordEventDto.setConsumerScanCodeDto(consumerScanCodeDtoForm);
            } else {
                scanCodeRecordEventDto.setConsumerScanCodeDto(scanCodeRecordDto.getConsumerScanCodeDto());
            }
            for (ConsumerScanCodeRecordEventListener consumerScanCodeRecordEventListener : this.consumerScanCodeRecordEventListeners) {
                if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException())) {
                    consumerScanCodeRecordEventListener.onSuccessScan(scanCodeRecordEventDto);
                    continue;
                }
                consumerScanCodeRecordEventListener.onFailScan(scanCodeRecordEventDto);
            }
        }
        if (!CollectionUtils.isEmpty(this.scanCodeRecordEventListeners)) {
            for (ScanCodeRecordEventListener scanCodeRecordEventListener : this.scanCodeRecordEventListeners) {
                if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException()) && (ScanCodeJudgeEnum.PROFIT_OUT.getCode().equals(scanCodeRecordDto.getScanCodeJudge()) || ScanCodeJudgeEnum.PROFIT_IN.getCode().equals(scanCodeRecordDto.getScanCodeJudge()))) {
                    scanCodeRecordEventListener.onSuccessScan(scanCodeRecordEventDto);
                    continue;
                }
                scanCodeRecordEventListener.onFailScan(scanCodeRecordEventDto);
            }
        }
        if (ScanCodeExceptionEnum.NO.getCode().equals(scanCodeRecordDto.getScanCodeException())) {
            this.scanSuccessCallback(scanCodeRecordDto.getBarCode());
        }
    }

    private void scanSuccessCallback(String barCode) {
        String scanSuccessCallbackUrl = this.barCodeConfig.getScanSuccessCallbackUrlList();
        if (StringUtils.isBlank((CharSequence)scanSuccessCallbackUrl)) {
            return;
        }
        List<ScanCodeRecordVo> byScanParticipatorCodeAndBarCode = this.scanCodeRecordVoRepository.findByScanParticipatorCodeAndBarCode(this.loginUserService.getLoginUser().getConsumerCode(), barCode);
        if (CollectionUtils.isEmpty(byScanParticipatorCodeAndBarCode)) {
            return;
        }
        ScanCodeRecordVo scanCodeRecordVo = byScanParticipatorCodeAndBarCode.get(0);
        if (Objects.isNull(scanCodeRecordVo)) {
            return;
        }
        try {
            String[] split = scanSuccessCallbackUrl.split(";");
            for (int i = 0; i < split.length; ++i) {
                this.restTemplate.postForObject(split[i], (Object)scanCodeRecordVo, null, new Object[0]);
            }
        }
        catch (RuntimeException e) {
            log.warn("\u56de\u8c03\u5916\u90e8\u7cfb\u7edf\u9519\u8bef\uff01");
        }
    }
}

