/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.barcode.sdk.common.enums;

import com.alibaba.excel.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public enum ScanCodeExceptionEnum {
    NO("0", "\u65e0"),
    REPEAT_SCAN("1", "\u91cd\u590d\u626b\u7801"),
    BOX("2", "\u5df2\u626b\u8fc7\u7bb1\u7801\uff0c\u5bf9\u5e94\u7684\u76d2\u7801\u4f5c\u5e9f\uff01"),
    BOTTLE("3", "\u5df2\u626b\u8fc7\u76d2\u7801\uff0c\u5bf9\u5e94\u7684\u7bb1\u7801\u4f5c\u5e9f\uff01"),
    CROSS_CUSTOMER("4", "\u8de8\u5ba2\u6237\u626b\u7801\u5f02\u5e38");

    private String code;
    private String des;

    private ScanCodeExceptionEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static Set<String> codeToSet() {
        HashSet<String> codes = new HashSet<String>();
        for (ScanCodeExceptionEnum enableStatusEnum : ScanCodeExceptionEnum.values()) {
            codes.add(enableStatusEnum.getCode());
        }
        return codes;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty((Object)code)) {
            ScanCodeExceptionEnum[] values;
            for (ScanCodeExceptionEnum value : values = ScanCodeExceptionEnum.values()) {
                if (!value.code.equals(code)) continue;
                return value.des;
            }
        }
        return null;
    }

    public static boolean contains(String code) {
        ScanCodeExceptionEnum[] values;
        if (StringUtils.isEmpty((Object)code)) {
            return false;
        }
        for (ScanCodeExceptionEnum value : values = ScanCodeExceptionEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return true;
        }
        return false;
    }
}

