package com.biz.crm.cps.external.mdm.local.controller;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author yinwenjie
 */
@Api(tags = "对接外部mdm —— crm系统登录人员信息信息")
@Slf4j
@RestController
@RequestMapping("/v1/mdm/loginUser")
public class LogUserController {

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired
  private TerminalMdmService terminalMdmService;

  /**
   * 通过主键查询终端信息
   * @return 终端信息VO
   */
  @ApiOperation(value = "获取登录信息")
  @GetMapping(value="getLoginInfo")
  public Result<LoginUserDetailsForCPS> getLoginInfo() {
    try {
      return Result.ok(loginUserService.getLoginDetails(LoginUserDetailsForCPS.class));
    } catch (RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 切换终端
   *
   * @return 终端信息VO
   */
  @ApiOperation(value = "切换终端")
  @PatchMapping(value = "handleChangeTerminal")
  public Result<?> handleChangeTerminal(@RequestParam String terminalCode) {
    try {
      this.terminalMdmService.handleChangeTerminal(terminalCode);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
