package com.biz.crm.cps.external.mdm.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.MaterialMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialGroupMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMdmVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 对接外部mdm —— 物料信息
 * @author hecheng
 */
@Api(tags = "对接外部mdm —— 物料信息")
@Slf4j
@RestController
@RequestMapping("/v1/mdm/material")
public class MaterialMdmController {

  @Autowired(required = false)
  private MaterialMdmService materialMdmService;

  /**
   * 按条件拉取【MDM】已有终端
   *
   * @return
   */

  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<MaterialMdmVo>> findByConditions(@PageableDefault(50) Pageable pageable, MaterialMdmPaginationDto materialMdmPaginationDto) {
    try {
      Page<MaterialMdmVo> result = this.materialMdmService.findByConditions(pageable,materialMdmPaginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findGroupByConditions")
  public Result<Page<MaterialGroupMdmVo>> findByConditions(@PageableDefault(50) Pageable pageable, MaterialGroupMdmPaginationDto dto) {
    try {
      Page<MaterialGroupMdmVo> result = this.materialMdmService.findByConditions(pageable,dto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

}
