package com.biz.crm.cps.external.mdm.local.controller;

import com.biz.crm.cps.external.mdm.sdk.service.ParticipatorMdmService;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXOpenVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

/**
 * 参与者
 *
 * @author 何成
 */
@Api(tags = "参与者")
@Slf4j
@Controller
@RequestMapping("/v1/mdm/participator")
public class ParticipatorMdmController {

  @Autowired
  private ParticipatorMdmService participatorMdmService;
  @Autowired(required = false)
  private WXOpenVoService wxOpenService;

  /**
   * 获取微信网页授权code
   *
   * @param redirectUri
   * @param appType
   * @return
   */
  @ApiOperation(value = "绑定微信")
  @GetMapping("/bindWxOpenId")
  public ModelAndView bindWxOpenId(@ApiParam("重定向url") @RequestParam String redirectUri, @RequestParam String code,
          @ApiParam("应用类型") @RequestParam(required = false) String appType) {
    String openid = participatorMdmService.bindWxOpenId(code, appType);
    ModelAndView mv = new ModelAndView("redirect:" + redirectUri + "?openid=" + openid);
    return mv;
  }

  @ApiOperation(value = "获取openId")
  @GetMapping("/findOpenId")
  public ModelAndView findOpenId(@ApiParam("重定向url") @RequestParam String redirectUri, @RequestParam(required = false) String code,
          @ApiParam("应用类型") @RequestParam(required = false) String appType, HttpServletRequest request) {
    if (this.isWeChat(request)) {
      Validate.notBlank(code, "微信环境下code不能为空");
    }
    WxWebViewAccessTokenRespVo accessTokenRespVo = wxOpenService.findWebViewAccessToken(code, appType);
    String openId = null;
    if (accessTokenRespVo != null) {
      openId = accessTokenRespVo.getOpenid();
    }
    ModelAndView mv = new ModelAndView("redirect:" + redirectUri + "?openid=" + openId);
    return mv;
  }

  /**
   * 判断是否是微信访问
   *
   * @param request
   * @return
   */
  private boolean isWeChat(HttpServletRequest request) {
    String userAgent = request.getHeader("user-agent").toLowerCase();
    boolean flag = userAgent == null || userAgent.indexOf("micromessenger") <= 0 ? false : true;
    if(!flag){
      log.warn("非微信浏览器访问");
    }
    return flag;
  }
}
