package com.biz.crm.cps.external.mdm.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.external.mdm.sdk.dto.TerminalMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author hefan
 */
@Api(tags = "对接外部mdm —— 终端信息")
@Slf4j
@RestController
@RequestMapping("/v1/mdm/terminal")
public class TerminalMdmController {

  @Autowired(required = false)
  private TerminalMdmService terminalMdmService;

  /**
   * 按条件拉取【MDM】已有终端
   *
   * @return
   */

  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;")
  @GetMapping("findByConditions")
  public Result<Page<TerminalMdmVo>> findByConditions(@PageableDefault(50) Pageable pageable, TerminalMdmPaginationDto terminalMdmPaginationDto) {
    try {
      Page<TerminalMdmVo> result = this.terminalMdmService.findByConditions(pageable,terminalMdmPaginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询终端信息
   * @return 终端信息VO
   */
  @ApiOperation(value = "通过主键查询终端详细信息")
  @GetMapping(value="/{id}")
  public Result<TerminalMdmVo> findById(@PathVariable("id") @ApiParam(name="id" , value="主键")String id) {
    try {
      TerminalMdmVo result = this.terminalMdmService.findById(id);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过电话号码查询终端信息
   * @return 终端信息VO
   */
  @ApiOperation(value = "通过电话号码查询终端信息")
  @GetMapping(value="findByPhone")
  public Result<List<TerminalMdmVo>> findByPhone(@RequestParam("phone") @ApiParam(name="phone" , value="电话号码")String phone) {
    try {
      List<TerminalMdmVo> result = this.terminalMdmService.findByPhone(phone);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}