package com.biz.crm.cps.external.mdm.local.service.internal;

import com.biz.crm.cps.external.mdm.sdk.service.DealerMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerCommunicationMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerContactPersonMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DealerMdmVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerContactVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerDockingVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerRelateOrgVo;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 经销商调用外部mdm的serviceImpl
 *
 * @author hefan
 */
@Service
@ConditionalOnMissingBean(name = "TDealerMdmServiceExpandImpl")
public class DealerMdmServiceImpl implements DealerMdmService {

  @Resource
  private CustomerVoService customerVoService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<DealerMdmVo> findByCustomerCodes(Collection<String> subtract) {
    /**
     * 就是一个拷贝数据的过程，但属性名称又取得不一样。
     */
    if (CollectionUtils.isEmpty(subtract)) {
      return null;
    }
    List<CustomerVo> list = this.customerVoService.findByCustomerCodes(Lists.newArrayList(subtract));
    if (CollectionUtils.isEmpty(list)) {
      return null;
    }
    List<DealerMdmVo> dealerMdmVos = Lists.newLinkedList();
    for (CustomerVo customerVo : list) {
      DealerMdmVo dealerMdmVo = this.nebulaToolkitService.copyObjectByWhiteList(customerVo, DealerMdmVo.class, HashSet.class, LinkedList.class);
      dealerMdmVo.setChannelCode(customerVo.getChannel());
      dealerMdmVo.setLegalRepresent(customerVo.getLegalRepresentative());
      List<CustomerContactVo> mdmCustomerContactVos = customerVo.getContactList();
      if (!CollectionUtils.isEmpty(mdmCustomerContactVos)) {
        Set<DealerContactPersonMdmVo> dealerContactPersons = Sets.newHashSet();
        for (CustomerContactVo mdmCustomerContactVo : mdmCustomerContactVos) {
          DealerContactPersonMdmVo dealerContactPersonMdmVo = new DealerContactPersonMdmVo();
          dealerContactPersonMdmVo.setContactPersonName(mdmCustomerContactVo.getContactName());
          dealerContactPersonMdmVo.setContactPersonPhone(mdmCustomerContactVo.getContactPhone());
          dealerContactPersonMdmVo.setDealerId(customerVo.getId());
          dealerContactPersons.add(dealerContactPersonMdmVo);
        }
        dealerMdmVo.setDealerContactPersons(dealerContactPersons);
      }

      List<CustomerDockingVo> mdmCustomerDockingVos = customerVo.getDockingList();
      if (!CollectionUtils.isEmpty(mdmCustomerDockingVos)) {
        Set<DealerCommunicationMdmVo> dealerCommunicationMdmVos = Sets.newHashSet();
        for (CustomerDockingVo mdmCustomerDockingVo : mdmCustomerDockingVos) {
          DealerCommunicationMdmVo dealerCommunicationMdmVo = new DealerCommunicationMdmVo();
          dealerCommunicationMdmVo.setPositionCode(mdmCustomerDockingVo.getPositionCode());
          dealerCommunicationMdmVo.setPositionName(mdmCustomerDockingVo.getPositionName());
          dealerCommunicationMdmVo.setUserCode(mdmCustomerDockingVo.getUserName());
          dealerCommunicationMdmVo.setUserName(mdmCustomerDockingVo.getFullName());
          dealerCommunicationMdmVo.setCommunicationOrgCode(mdmCustomerDockingVo.getOrgCode());
          dealerCommunicationMdmVo.setCommunicationOrgName(mdmCustomerDockingVo.getOrgName());
          dealerCommunicationMdmVo.setCommunicationContact(mdmCustomerDockingVo.getContact());
          dealerCommunicationMdmVo.setDealerId(customerVo.getId());
          dealerCommunicationMdmVos.add(dealerCommunicationMdmVo);
        }
        dealerMdmVo.setDealerCommunications(dealerCommunicationMdmVos);
      }
      List<CustomerRelateOrgVo> orgList = customerVo.getOrgList();
      if (!CollectionUtils.isEmpty(orgList)) {
        dealerMdmVo.setOrgCode(orgList.stream().map(CustomerRelateOrgVo::getOrgCode).collect(Collectors.joining(",")));
        dealerMdmVo.setOrgName(orgList.stream().map(CustomerRelateOrgVo::getOrgName).collect(Collectors.joining(",")));
      }
      dealerMdmVos.add(dealerMdmVo);
    }
    return dealerMdmVos;
  }
}
