package com.biz.crm.cps.external.mdm.local.service.internal;

import com.biz.crm.cps.external.mdm.sdk.service.DictMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.DictTypeVo;
import com.biz.crm.cps.external.mdm.sdk.vo.DictVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: HuaHongQiang
 * @Date: 2021/8/10 18:59
 * 在外部mdm系统操作数据字典的实现类
 */
@Service
public class DictMdmServiceImpl implements DictMdmService {

  public final String PATH_SPLIT = "/";
  @Autowired
  private DictDataVoService dictDataVoService;
  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<DictTypeVo> findByTypeCodes(List<String> dictTypeCodes) {
    if (CollectionUtils.isEmpty(dictTypeCodes)) {
      return null;
    }
    List<DictTypeVo> list = Lists.newArrayList();
    if (!CollectionUtils.isEmpty(dictTypeCodes)) {
      for (String dictTypeCode : dictTypeCodes) {
        DictTypeVo dictTypeVo = new DictTypeVo();
        dictTypeVo.setDictTypeCode(dictTypeCode);
        dictTypeVo.setDictVos(findByTypeCode(dictTypeCode));
        list.add(dictTypeVo);
      }
    }
    return list;
  }

  @Override
  public List<DictVo> findByTypeCode(String dictTypeCode) {
    if (!StringUtils.isEmpty(dictTypeCode)) {
      List<DictDataVo> list = findDictDataByPath(dictTypeCode);
      if (!CollectionUtils.isEmpty(list)) {
        Collection<DictVo> dictVos = nebulaToolkitService
            .copyCollectionByWhiteList(list, DictDataVo.class, DictVo.class, HashSet.class, ArrayList.class);
        return dictVos.stream().sorted(Comparator.comparing(DictVo::getDictSort))
            .collect(Collectors.toList());
      }
    }
    return null;
  }


  /**
   * 获取路径下（不含路径）的字典集合
   *
   * @param path 路径
   * @return
   */
  private List<DictDataVo> findDictDataByPath(String path) {
    List<DictDataVo> list = Lists.newArrayList();
    if (!StringUtils.isEmpty(path)) {
      List<com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo> dataVoList = this.findDictGroupByTypeCode(path);
      if (CollectionUtils.isEmpty(dataVoList)) {
        return list;
      }
      for (com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo item : dataVoList) {
        String path2 = path + PATH_SPLIT;
        if (!item.getPath().startsWith(path2)) {
          continue;
        }
        DictDataVo copy = nebulaToolkitService
            .copyObjectByWhiteList(item, DictDataVo.class, HashSet.class, ArrayList.class);
        list.add(copy);
      }
    }
    return list;
  }

  /**
   * 获取字典组
   *
   * @param dictTypeCode 字典类型编码
   * @return
   */
  private List<com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo> findDictGroupByTypeCode(String dictTypeCode) {
    if (!StringUtils.isEmpty(dictTypeCode)) {
      Map<String, List<com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo>> resultMap = this.dictDataVoService.findByDictTypeCodeList(Collections.singletonList(dictTypeCode));
      if (resultMap == null || resultMap.isEmpty()) {
        return null;
      }
      return resultMap.get(dictTypeCode);
    }
    return null;
  }

}
