package com.biz.crm.cps.external.mdm.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialGroupMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.dto.MaterialMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.service.MaterialMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialGroupMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.MaterialMediaMdmVo;
import com.biz.crm.cps.external.mdm.sdk.vo.ProductLevelMdmVo;
import com.biz.crm.mdm.business.material.sdk.dto.MaterialPageDto;
import com.biz.crm.mdm.business.material.sdk.service.MaterialVoService;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialMediaVo;
import com.biz.crm.mdm.business.material.sdk.vo.MaterialVo;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author hecheng
 * @description: mdm 物料信息实现
 * @date 2021/8/20 下午1:45
 */
@Service
@ConditionalOnMissingBean(name = "MaterialMdmServiceExpandImpl")
public class MaterialMdmServiceImpl implements MaterialMdmService {

  @Autowired
  private MaterialVoService materialVoService;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 分页条件查询外部已经存在的物料数据
   * <pre>
   *  1  物料信息
   *  2  包含物料所属的层级 从子节点到最上层父节点
   *  </pre>
   *
   * @param pageable
   * @param materialMdmPaginationDto
   * @return
   */
  @Override
  public Page<MaterialMdmVo> findByConditions(Pageable pageable,
                                              MaterialMdmPaginationDto materialMdmPaginationDto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    MaterialPageDto materialPageDto = this.nebulaToolkitService.copyObjectByWhiteList(materialMdmPaginationDto, MaterialPageDto.class, HashSet.class, ArrayList.class);
    materialPageDto.setModifyEndDate(materialMdmPaginationDto.getEndDate());
    materialPageDto.setModifyStartDate(materialMdmPaginationDto.getStartDate());
    materialPageDto.setProductLevelCodes(materialMdmPaginationDto.getProductLevelCodes());
    materialPageDto.setMaterialCodes(materialMdmPaginationDto.getMaterialCodes());
    Page<MaterialVo> result = this.materialVoService.findByMaterialPageDto(pageable, materialPageDto);
    Page<MaterialMdmVo> page = new Page<>();
    if (result != null) {
      List<MaterialMdmVo> materialRespVos = result.getRecords().stream().map(item -> {
        MaterialMdmVo vo = this.nebulaToolkitService.copyObjectByWhiteList(item, MaterialMdmVo.class, HashSet.class, ArrayList.class);
        //物料层级
        List<ProductLevelVo> mdmLevelMdmVos = item.getProductLevels();
        if (!CollectionUtils.isEmpty(mdmLevelMdmVos)) {
          List<ProductLevelMdmVo> levelMdmVos = mdmLevelMdmVos.stream().map(productLevelVo -> {
            ProductLevelMdmVo mdmVo = new ProductLevelMdmVo();
            BeanUtils.copyProperties(productLevelVo, mdmVo, "productLevelType");
            mdmVo.setProductLevelType(productLevelVo.getProductLevelType() != null ? productLevelVo.getProductLevelType().getCode() : null);
            return mdmVo;
          }).collect(Collectors.toList());
          vo.setProductLevels(levelMdmVos);
        } else {
          vo.setProductLevels(Lists.newArrayList());
        }
        //物料图片
        List<MaterialMediaVo> picList = item.getPicList();
        if (!CollectionUtils.isEmpty(picList)) {
          List<MaterialMediaMdmVo> mediaMdmVos = (List<MaterialMediaMdmVo>) this.nebulaToolkitService.copyCollectionByWhiteList(picList, MaterialMediaVo.class, MaterialMediaMdmVo.class, HashSet.class, ArrayList.class);
          vo.setMaterialMedias(mediaMdmVos);
        } else {
          vo.setMaterialMedias(Lists.newArrayList());
        }
        return vo;
      }).collect(Collectors.toList());
      page.setTotal(result.getTotal());
      page.setCurrent(result.getCurrent());
      page.setSize(result.getSize());
      page.setRecords(materialRespVos);
    } else {
      page.setRecords(Lists.newArrayList());
    }
    return page;
  }

  /**
   * 分页条件查询外部已经存在的物料数据
   * <pre>
   *  1  物料组信息
   *  2  物料信息
   *  3  物料包含物料所属的层级 从子节点到最上层父节点
   *  </pre>
   *
   * @param pageable
   * @param materialGroupMdmPaginationDto
   * @return
   */
  @Override
  public Page<MaterialGroupMdmVo> findByConditions(Pageable pageable, MaterialGroupMdmPaginationDto materialGroupMdmPaginationDto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    materialGroupMdmPaginationDto.setPageNum(pageable.getPageNumber());
    materialGroupMdmPaginationDto.setPageSize(pageable.getPageSize());
    //TODO 此处由于crm3.0没有物料组的模块,所以待定
//    MdmMaterialGroupReqVo req = new MdmMaterialGroupReqVo();
//    BeanUtils.copyProperties(materialGroupMdmPaginationDto, req);
    //MdmMaterialGroupReqVo req = this.nebulaToolkitService.copyObjectByWhiteList(materialGroupMdmPaginationDto, MdmMaterialGroupReqVo.class, HashSet.class, ArrayList.class);
//    PageResult<MdmMaterialGroupRespVo> result = mdmMaterialService.pageGroupCpsList(req);
//    Page<MaterialGroupMdmVo> page = new Page<>();
//    if (result != null) {
//      //物料组
//      List<MaterialGroupMdmVo> materialGroupMdmVos = result.getData().stream().map(item -> {
//        MaterialGroupMdmVo vo = new MaterialGroupMdmVo();
//        //这里存在 类型不匹配 所以使用BeanUtils.copyProperties
//        BeanUtils.copyProperties(item, vo, "materialNum");
//        try {
//          BigDecimal materialNum = new BigDecimal(String.valueOf(item.getMaterialNum())).setScale(4, RoundingMode.HALF_UP);
//          vo.setMaterialNum(materialNum);
//        } catch (NumberFormatException e) {
//          throw new NumberFormatException("materialNum格式不正确");
//        }
////        MaterialGroupMdmVo vo = this.nebulaToolkitService.copyObjectByWhiteList(item, MaterialGroupMdmVo.class, HashSet.class, ArrayList.class);
//        //物料
//        List<MdmMaterialRespVo> mdmMaterialList = item.getMaterialList();
//        if (!CollectionUtils.isEmpty(mdmMaterialList)) {
//          List<MaterialMdmVo> materialMdmVos = mdmMaterialList.stream().map(temp -> {
//            MaterialMdmVo materialMdmVo = this.nebulaToolkitService.copyObjectByWhiteList(temp, MaterialMdmVo.class, HashSet.class, ArrayList.class);
//            //物料层级
//            List<MdmProductLevelVo> mdmLevelMdmVos = temp.getProductLevels();
//            if (!CollectionUtils.isEmpty(mdmLevelMdmVos)) {
//              List<ProductLevelMdmVo> levelMdmVos = (List<ProductLevelMdmVo>) this.nebulaToolkitService.copyCollectionByWhiteList(mdmLevelMdmVos, MdmProductLevelVo.class, ProductLevelMdmVo.class, HashSet.class, ArrayList.class);
//              materialMdmVo.setProductLevels(levelMdmVos);
//            } else {
//              materialMdmVo.setProductLevels(Lists.newArrayList());
//            }
//            //物料图片
//            List<MdmMaterialMediaRespVo> picList = temp.getPicList();
//            if (!CollectionUtils.isEmpty(picList)) {
//              List<MaterialMediaMdmVo> mediaMdmVos = (List<MaterialMediaMdmVo>) this.nebulaToolkitService.copyCollectionByWhiteList(picList, MdmMaterialMediaRespVo.class, MaterialMediaMdmVo.class, HashSet.class, ArrayList.class);
//              materialMdmVo.setMaterialMedias(mediaMdmVos);
//            } else {
//              materialMdmVo.setMaterialMedias(Lists.newArrayList());
//            }
//            return materialMdmVo;
//          }).collect(Collectors.toList());
//          vo.setMaterialMdmVos(materialMdmVos);
//        } else {
//          vo.setMaterialMdmVos(Lists.newArrayList());
//        }
//        return vo;
//      }).collect(Collectors.toList());
//      page.setCurrent(result.getCount());
//      page.setRecords(materialGroupMdmVos);
//    } else {
//      page.setRecords(Lists.newArrayList());
//    }
    return new Page<>();
  }
}
