package com.biz.crm.cps.external.mdm.local.service.internal;

import com.biz.crm.business.common.sdk.enums.LoginFromTypeEnum;
import com.biz.crm.cps.external.mdm.sdk.service.ParticipatorMdmService;
import com.biz.crm.cps.external.weixinsign.sdk.service.WXOpenVoService;
import com.biz.crm.cps.external.weixinsign.sdk.vo.WxWebViewAccessTokenRespVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserWeChatBindDto;
import com.biz.crm.mdm.business.user.sdk.service.UserRelWeChatVoService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author hecheng
 * @description: 参与者对接mdm接口定义
 * @date 2021/10/9 下午2:39
 */
@Service
@Slf4j
public class ParticipatorMdmServiceImpl implements ParticipatorMdmService {

  @Autowired(required = false)
  private WXOpenVoService wxOpenService;
  @Autowired(required = false)
  private UserRelWeChatVoService userRelWeChatVoService;

  @Override
  public String bindWxOpenId(String code, String appType) {
    Validate.notBlank(code, "微信网页授权code不能为空");
    WxWebViewAccessTokenRespVo accessTokenRespVo = wxOpenService.findWebViewAccessToken(code, appType);
    if (accessTokenRespVo == null) {
      return null;
    }
    //由mdm方法内部判断是否是重复绑定
    UserWeChatBindDto dto = new UserWeChatBindDto();
    dto.setOriginModule(LoginFromTypeEnum.APPLET_TERMINAL.getValue());
    dto.setOpenId(accessTokenRespVo.getOpenid());
    this.userRelWeChatVoService.createByUserWeChatBindDto(dto);
    // 调用mdm绑定微信openid
    return accessTokenRespVo.getOpenid();
  }
}
