package com.biz.crm.cps.external.mdm.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.external.mdm.sdk.dto.TerminalMdmPaginationDto;
import com.biz.crm.cps.external.mdm.sdk.event.TerminalMdmEventListener;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.TerminalMdmVo;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaCustomerOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mdm.business.terminal.user.sdk.service.TerminalUserVoService;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserRelaTerminalVo;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author jerry7
 * @date 2021-07-26
 * mdm终端信息实现类
 */
@Service
@Slf4j
@ConditionalOnMissingBean(name = "TerminalMdnServiceExpandImpl")
public class TerminalMdnServiceImpl implements TerminalMdmService,CopyObjectCallback<TerminalVo, TerminalMdmVo> {

  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private List<TerminalMdmEventListener> terminalMdmEventListeners;
  @Autowired
  private TerminalVoService terminalVoService;
  @Autowired
  private TerminalUserVoService terminalUserVoService;
  @Autowired
  private LoginUserService loginUserService;

  @Override
  public Page<TerminalMdmVo> findByConditions(Pageable pageable, TerminalMdmPaginationDto terminalMdmPaginationDto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (terminalMdmPaginationDto == null) {
      terminalMdmPaginationDto = new TerminalMdmPaginationDto();
    }
    // 查询已经被使用的终端code集合
    if (!CollectionUtils.isEmpty(terminalMdmEventListeners)) {
      List<String> list = Lists.newLinkedList();
      for (TerminalMdmEventListener listener : terminalMdmEventListeners) {
        List<String> codes = listener.onFind();
        list.addAll(codes);
      }
      terminalMdmPaginationDto.setNotIncludeTerminalCodeList(list);
    }
    TerminalPaginationDto dto = new TerminalPaginationDto();
    dto.setTerminalCode(terminalMdmPaginationDto.getTerminalCode());
    dto.setTerminalName(terminalMdmPaginationDto.getTerminalName());
    dto.setOrgCode(terminalMdmPaginationDto.getOrganization());
    dto.setChannel(terminalMdmPaginationDto.getChannel());
    dto.setTerminalType(terminalMdmPaginationDto.getTerminalType());
    dto.setTagName(terminalMdmPaginationDto.getTerminalLabel());
    dto.setNotIncludeTerminalCodeList(terminalMdmPaginationDto.getNotIncludeTerminalCodeList());
    Page<TerminalVo> result = this.terminalVoService.findByTerminalPaginationDto(pageable, dto);
    if (Objects.isNull(result)) {
      return null;
    }
    List<TerminalMdmVo> terminalMdmVos = (List<TerminalMdmVo>) this.nebulaToolkitService.copyCollectionByWhiteList(result.getRecords(), TerminalVo.class, TerminalMdmVo.class, HashSet.class, ArrayList.class);
    Page<TerminalMdmVo> page = new Page<>();
    page.setTotal(result.getTotal());
    page.setCurrent(result.getCurrent());
    page.setSize(result.getSize());
    page.setRecords(terminalMdmVos);
    return page;
  }

  @Override
  public List<TerminalMdmVo> findByConditions(TerminalMdmPaginationDto terminalMdmPaginationDto) {
    if (terminalMdmPaginationDto == null) {
      terminalMdmPaginationDto = new TerminalMdmPaginationDto();
    }
    TerminalPaginationDto dto = new TerminalPaginationDto();
    dto.setTerminalCode(terminalMdmPaginationDto.getTerminalCode());
    dto.setTerminalName(terminalMdmPaginationDto.getTerminalName());
    dto.setOrgCode(terminalMdmPaginationDto.getOrganization());
    dto.setChannel(terminalMdmPaginationDto.getChannel());
    Page<TerminalVo> result = this.terminalVoService.findByTerminalPaginationDto(PageRequest.of(0, 50), dto);
    if (Objects.nonNull(result) && !CollectionUtils.isEmpty(result.getRecords())) {
      return (List<TerminalMdmVo>) nebulaToolkitService.copyCollectionByWhiteList(result.getRecords(), TerminalVo.class, TerminalMdmVo.class, HashSet.class, ArrayList.class);
    }
    return Lists.newLinkedList();
  }

  @Override
  public TerminalMdmVo findDetailByRegisterOrName(TerminalMdmPaginationDto terminalMdmPaginationDto) {
    //校验终端是否已经存在，需要同时传入营业执照编号，终端名称，终端地址进行校验，缺少任意一个字段则返回空
    if (StringUtils.isAnyBlank(terminalMdmPaginationDto.getLicenseRegisterNumber(), terminalMdmPaginationDto.getTerminalAddress(), terminalMdmPaginationDto.getTerminalName())) {
      return null;
    }
    //step1:先用营业注册编码进行查询
    TerminalPaginationDto registerDto = new TerminalPaginationDto();
    registerDto.setLicenseRegisterNumber(terminalMdmPaginationDto.getLicenseRegisterNumber());
    Page<TerminalVo> result = this.terminalVoService.findByTerminalPaginationDto(PageRequest.of(0, 50), registerDto);
    if (Objects.nonNull(result) && !CollectionUtils.isEmpty(result.getRecords())) {
      return nebulaToolkitService.copyObjectByWhiteList(result.getRecords().get(0), TerminalMdmVo.class, Set.class, ArrayList.class);
    }
    //step2:营业执照未查询到终端信息，则使用终端名称和终端地址进行查询
    TerminalPaginationDto addressDto = new TerminalPaginationDto();
    addressDto.setTerminalName(terminalMdmPaginationDto.getTerminalName());
    addressDto.setTerminalAddress(terminalMdmPaginationDto.getTerminalAddress());
    result = this.terminalVoService.findByTerminalPaginationDto(PageRequest.of(0, 50), addressDto);
    if (Objects.nonNull(result) && !CollectionUtils.isEmpty(result.getRecords())) {
      return nebulaToolkitService.copyObjectByWhiteList(result.getRecords().get(0), TerminalMdmVo.class, Set.class, ArrayList.class);
    }
    return null;
  }

  @Override
  public TerminalMdmVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return new TerminalMdmVo();
    }
    List<TerminalVo> list = this.terminalVoService.findDetailsByIdsOrTerminalCodes(Lists.newArrayList(id), null);
    if (!CollectionUtils.isEmpty(list)) {
      return nebulaToolkitService.copyObjectByWhiteList(list.get(0), TerminalMdmVo.class, Set.class, ArrayList.class);
    } else {
      return new TerminalMdmVo();
    }
  }

  @Override
  @Transactional
  public void save(TerminalMdmVo terminalMdmVo) {
    Validate.notNull(terminalMdmVo, "保存终端信息到mdm时，数据不能为空");
    Validate.notBlank(terminalMdmVo.getTerminalName(), "终端名称不能为空");
    TerminalDto dto = this.nebulaToolkitService.copyObjectByBlankList(terminalMdmVo, TerminalDto.class, HashSet.class, ArrayList.class);
    dto.setFromType("cps");
    log.info("推送mdm终端数据={}", JSON.toJSONString(dto));
    this.terminalVoService.create(dto);
  }

  @Override
  public List<TerminalMdmVo> findDetailByCodes(Set<String> codes) {
    List<TerminalVo> resultList = this.terminalVoService.findMainDetailsByTerminalCodes(Lists.newArrayList(codes));
    if (!CollectionUtils.isEmpty(resultList)) {
      return (List<TerminalMdmVo>) this.nebulaToolkitService.copyCollectionByBlankList(resultList, TerminalVo.class, TerminalMdmVo.class, HashSet.class, LinkedList.class);
    }
    return Lists.newLinkedList();
  }

  /**
   * 通过电话号码查询终端信息
   *
   * @param phone
   * @return
   */
  @Override
  public List<TerminalMdmVo> findByPhone(String phone) {
    if (StringUtils.isBlank(phone)) {
      return Lists.newLinkedList();
    }
    TerminalUserVo terminalUserVo = this.terminalUserVoService.findByUserPhone(phone);
    if (Objects.isNull(terminalUserVo) || CollectionUtils.isEmpty(terminalUserVo.getTerminalList())) {
      return Lists.newLinkedList();
    }
    List<String> terminalCodes = terminalUserVo.getTerminalList().stream().map(TerminalUserRelaTerminalVo::getTerminalCode).collect(Collectors.toList());
    List<TerminalVo> resultList = this.terminalVoService.findDetailsByIdsOrTerminalCodes(null, terminalCodes);
    if (CollectionUtils.isEmpty(resultList)) {
      return Lists.newLinkedList();
    }
    return (List<TerminalMdmVo>) this.nebulaToolkitService.copyCollectionByBlankList(resultList, TerminalVo.class, TerminalMdmVo.class, HashSet.class, LinkedList.class);
  }


  @Override
  public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
    return TerminalVo.class.isAssignableFrom(sourceClass) && TerminalMdmVo.class.isAssignableFrom(targetClass);
  }

  @Override
  public void callback(Class<TerminalVo> sourceClass, List<TerminalVo> sourceObjects, Class<TerminalMdmVo> targetClass, List<TerminalMdmVo> targetObjects) {
    for (int i = 0; i < sourceObjects.size(); i++) {
      TerminalVo sourceObject = sourceObjects.get(i);
      TerminalMdmVo targetObject = targetObjects.get(i);
      if (!CollectionUtils.isEmpty(sourceObject.getOrgList())) {
        targetObject.setOrgCode(String.join(",",sourceObject.getOrgList().stream()
            .map(TerminalRelaOrgVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toList())));
        targetObject.setOrgName(String.join(",",sourceObject.getOrgList().stream()
            .map(TerminalRelaOrgVo::getOrgName).filter(Objects::nonNull).collect(Collectors.toList())));
      }
      if (!CollectionUtils.isEmpty(sourceObject.getCustomerOrgList())) {
        targetObject.setCustomerOrgCode(String.join(",",sourceObject.getCustomerOrgList().stream()
            .map(TerminalRelaCustomerOrgVo::getOrgCode).filter(Objects::nonNull).collect(Collectors.toList())));
        targetObject.setCustomerOrgName(String.join(",",sourceObject.getCustomerOrgList().stream()
            .map(TerminalRelaCustomerOrgVo::getOrgName).filter(Objects::nonNull).collect(Collectors.toList())));
      }
    }
  }


  @Override
  public void handleChangeTerminal(String terminalCode) {
    LoginUserDetailsForCPS loginDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginDetails, "未查询到登录信息，请登录！");
    List<TerminalUserVo> detailsByIdsOrUserCodes = this.terminalUserVoService.findDetailsByIdsOrUserCodes(null, Lists.newArrayList(loginDetails.getAccount()));
    Validate.isTrue(!CollectionUtils.isEmpty(detailsByIdsOrUserCodes), "未查询到登录用户信息，请登录！");
    TerminalUserVo terminalUserVo = detailsByIdsOrUserCodes.stream().findFirst().orElse(null);
    List<TerminalUserRelaTerminalVo> terminalList = terminalUserVo.getTerminalList();
    Validate.isTrue(!CollectionUtils.isEmpty(terminalList), "未查询到登录用户关联的终端信息，请检查！");
    TerminalUserRelaTerminalVo terminalUserRelaTerminalVo = terminalList.stream().filter(a -> a.getTerminalCode().equals(terminalCode)).findFirst().orElse(null);
    Validate.notNull(terminalUserRelaTerminalVo, "未查询到登录用户关联的终端信息，请检查！");
    //更新security的信息
    SecurityContext context = SecurityContextHolder.getContext();
    loginDetails.setConsumerCode(terminalUserRelaTerminalVo.getTerminalCode());
    loginDetails.setConsumerName(terminalUserRelaTerminalVo.getTerminalName());
    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(loginDetails.getAccount(), loginDetails.getPassword(), context.getAuthentication().getAuthorities());
    authentication.setDetails(loginDetails);
    context.setAuthentication(authentication);
  }
}
