//package com.biz.crm.cps.external.mdm.local.service.notifier;
//
//import com.alibaba.fastjson.JSON;
//import com.biz.crm.cps.external.mdm.sdk.constant.RocketMQConstant;
//import com.biz.crm.cps.external.mdm.sdk.event.ParticipatorMdmTagEventListener;
//import com.biz.crm.cps.external.mdm.sdk.vo.CustomerTagRefreshMdmVo;
//import com.biz.crm.cps.external.mdm.sdk.vo.RocketMQMessageBody;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
//import org.apache.rocketmq.spring.core.RocketMQListener;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Component;
//import org.springframework.transaction.annotation.Transactional;
//import org.springframework.util.CollectionUtils;
//
//import java.util.List;
//
///**
// * 接收客户标签刷新信息消费者
// *
// * @author ning.zhang
// * @date 2022/1/5
// */
//@Slf4j
//@Component
//@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
//    /**
//     * tag
//     * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
//    */
//    selectorExpression = RocketMQConstant.CRM_MQ_TAG.CUSTOMER_TAG_REFRESH,
///**
// * 相同分组下 consumer 可自动负载均衡
//*/
//    consumerGroup = RocketMQConstant.CONSUMER_GROUP.CUSTOMER_TAG_REFRESH + "${rocketmq.environment-variable}")
//public class CustomerTagRefreshConsumer implements RocketMQListener<RocketMQMessageBody> {
//
//  @Autowired(required = false)
//  private List<ParticipatorMdmTagEventListener> listeners;
//
//  @Override
//  @Transactional
//  public void onMessage(RocketMQMessageBody message) {
//    if (null == message) {
//      log.warn("消费MQ消息：RocketMQMessageBody 为空，忽略本次消费");
//      throw new IllegalArgumentException("消费MQ消息：RocketMQMessageBody 为空，忽略本次消费");
//    }
//    String json = JSON.toJSONString(message);
//    //丢失日志id
//    if (StringUtils.isBlank(message.getId())) {
//      log.warn("消费MQ消息，记录日志失败：message = {}", json);
//      //抛出异常
//      throw new IllegalArgumentException("消费MQ消息，失败：message = " + json);
//    }
//    try {
//      this.handleMessage(message);
//    } catch (InterruptedException e) {
//      log.error("消费MQ消息，记录日志失败：message = {} >>>", json, e);
//    }
//  }
//
//  /**
//   * 客户标签信息修改执行
//   *
//   * @param message
//   * @throws InterruptedException
//   */
//  private void handleMessage(RocketMQMessageBody message) throws InterruptedException {
//    log.info("客户标签信息更新开始-------------");
//    String msg = message.getMsgBody();
//    if (StringUtils.isEmpty(msg)) {
//      return;
//    }
//    log.info("客户标签信息：{}", msg);
//    CustomerTagRefreshMdmVo tagRefreshMdmVo = JSON.parseObject(msg, CustomerTagRefreshMdmVo.class);
//    if (tagRefreshMdmVo == null) {
//      log.info("客户标签信息为空");
//      return;
//    }
//    if (CollectionUtils.isEmpty(listeners)) {
//      log.info("客户标签信息监听为空");
//      return;
//    }
//    //此处应该执行客户标签信息更新操作
//    listeners.forEach(listener -> {
//      listener.onRefresh(tagRefreshMdmVo);
//    });
//    log.info("客户标签信息更新结束-------------");
//  }
//}
