/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.external.mdm.local.service.internal;

import com.biz.crm.cps.external.mdm.sdk.service.ParticipatorTagMdmService;
import com.biz.crm.cps.external.mdm.sdk.vo.ParticipatorTagMdmVo;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagRespVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"ParticipatorTagMdmExpandServiceImpl"})
public class ParticipatorTagMdmServiceImpl
implements ParticipatorTagMdmService {
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    public List<ParticipatorTagMdmVo> findTagsByCodes(Set<String> codes) {
        LinkedList participatorTagMdmVos = Lists.newLinkedList();
        if (CollectionUtils.isEmpty(codes)) {
            return participatorTagMdmVos;
        }
        Result result = this.mdmCustomerMsgFeign.queryTagByCodeList((List)Lists.newLinkedList(codes));
        if (!result.isSuccess()) {
            return participatorTagMdmVos;
        }
        List voList = (List)result.getResult();
        if (CollectionUtils.isEmpty((Collection)voList)) {
            return participatorTagMdmVos;
        }
        for (MdmCustomerTagRespVo vo : voList) {
            ParticipatorTagMdmVo participatorTagMdmVo = new ParticipatorTagMdmVo();
            participatorTagMdmVo.setParticipatorCode(vo.getClientCode());
            participatorTagMdmVo.setTagType(vo.getTagType());
            participatorTagMdmVo.setTagDescription(vo.getTagDescription());
            participatorTagMdmVos.add(participatorTagMdmVo);
        }
        return participatorTagMdmVos;
    }
}

